package com.digiwin.athena.dao;

import com.digiwin.athena.domain.CompiledData;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
@Slf4j
public class CompiledDataV2MongoDao {

    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;

    @Autowired
    public void setMongoSystemRepositoryDecorator(MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator) {
        this.mongoSystemRepositoryDecorator = mongoSystemRepositoryDecorator;
    }

    public void insert(CompiledData compiledData) {
        mongoSystemRepositoryDecorator.insert(compiledData);
    }

    public List<CompiledData> selectByApplication(String application) {
        Query query = new Query(Criteria.where("application").is(application));
        query.with(Sort.by(Sort.Direction.DESC,"_id"));
        return mongoSystemRepositoryDecorator.find(query,CompiledData.class);
    }

    public CompiledData selectByCode(String code) {
        Criteria criteria = Criteria.where("code").is(code);
        return mongoSystemRepositoryDecorator.findOne(new Query(criteria), CompiledData.class);
    }
}
