package com.digiwin.athena.dto;

import com.digiwin.athena.domain.CompiledData;
import com.digiwin.athena.domain.DeployLog;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

@Data
@Accessors(chain = true)
public class DeployLogResDto {
    private String serviceId;

    private String env;

    private String operate;

    private String compileCode;

    //最近一次成功的
    private String compileVersion;

    //最近一次成功的
    @JsonFormat(locale = "zh", timezone = "Asia/Shanghai", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date date;

    //最近一次的
    private String result;

    //最近一次的
    private String deployNo;

    public static DeployLogResDto create(DeployLog deployLog) {
        DeployLogResDto deployLogResDto = new DeployLogResDto();
        deployLogResDto.setDate(deployLog.getCreateDate());
        deployLogResDto.setResult(deployLogResDto.getResult());
        deployLogResDto.setDeployNo(deployLog.getDeployNo());
        deployLogResDto.setOperate(deployLog.getType());

        DeployParam deployParam = deployLog.getDeployParam();
        if (deployParam!=null){
            deployLogResDto.setServiceId(deployParam.getEnvServiceId());
            deployLogResDto.setEnv(deployParam.getEnv());
        }

        if (deployLog.getCompileData()!=null){
            CompiledData compileData = deployLog.getCompileData();
            deployLogResDto.setCompileCode(compileData.getCode());
            deployLogResDto.setCompileVersion(compileData.getVersion());
        }

        return deployLogResDto;
    }
}
