package com.digiwin.athena.controller;


import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.auth.annotation.DataAuth;
import com.digiwin.athena.auth.annotation.FuncAuth;
import com.digiwin.athena.dto.AppCompileDataResult;
import com.digiwin.athena.dto.CompileParam;
import com.digiwin.athena.dto.DeployBasicInfoResDto;
import com.digiwin.athena.dto.DeployDataDto;
import com.digiwin.athena.dto.DeployDetailInfoResDto;
import com.digiwin.athena.dto.DeployLogParamDto;
import com.digiwin.athena.dto.DeployLogResDto;
import com.digiwin.athena.dto.DeployParam;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.publish.Publish;
import com.digiwin.athena.service.DeployService;
import com.digiwin.athena.utils.GzipUtil;
import com.digiwin.athena.utils.SwitchDatabaseUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.extern.slf4j.Slf4j;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.util.List;

@RestController
@RequestMapping("/deploy")
@Slf4j
@Tag(name = "发版",description = "58267dc0-83f4-48b0-86e2-8f1a3ebd08d7")
public class DeployController {

    @Autowired
    private DeployService deployService;

    @Autowired
    private List<Publish> publishes;
    @PostMapping("/addDeployPlan")
    @Operation(summary = "添加发版任务")
    public ResultDto<String> addDeployPlan(@RequestBody DeployParam deployParam) {
        String deployNo = deployService.addDeployPlan(deployParam);
        return ResultDto.createSuccess(deployNo);
    }

    @PostMapping("/compile")
    @Operation(summary = "应用编译")
    public ResultDto<String> compile(@RequestBody CompileParam compileParam){
        String compiledCode = SwitchDatabaseUtils.switchBranchDatabase(compileParam.getBranch(),()-> deployService.compile(compileParam));
        return ResultDto.createSuccess(compiledCode);
    }

    @PostMapping("/queryCompileData")
    @Operation(summary = "查询编译版本")
    public ResultDto<List<AppCompileDataResult>> queryCompileData(@RequestBody List<String> applicationList) {
        List<AppCompileDataResult> result = deployService.queryCompileData(applicationList);
        return ResultDto.createSuccess(result);
    }

    @GetMapping("/queryDeployDetailByApplication")
    @Operation(summary = "查询发布日志")
    public ResultDto<DeployDetailInfoResDto> queryDeployDetail(@RequestParam("deployNo") String deployNo,
                                                               @RequestParam("application") String application) {
        DeployDetailInfoResDto deployDetailInfoResDto = deployService.queryDeployDetail(deployNo, application);
        return ResultDto.createSuccess(deployDetailInfoResDto);
    }

    @PostMapping("/releasePipeline/queryDeployLogByEnv")
    @Operation(summary = "查询上次发布成功记录")
    public ResultDto<List<DeployLogResDto>> queryDeployLogByEnv(@RequestBody DeployLogParamDto deployLogParamDto){
        List<DeployLogResDto> res = deployService.queryDeployLogByEnv(deployLogParamDto);
        return ResultDto.createSuccess(res);
    }

    @PostMapping("/modulePublish")
    public ResultDto<?> modulePublish(@RequestBody DeployDataDto deployDataDto) throws IOException {

        for (Publish publish : publishes) {
            String simpleName = AopUtils.getTargetClass(publish).getSimpleName();
            if (deployDataDto.getModuleType().equals(simpleName)){
                List list = publish.jsonStrToObject(JSONObject.parseObject(new String(GzipUtil.decompress(deployDataDto.getZipData())), String.class));
                deployDataDto.setPublishData(list);
                publish.publishAll(deployDataDto);
            }
        }
        return ResultDto.createSuccess(null);
    }

    @GetMapping("/releasePipeline/queryLatestDeployInfo")
    @Operation(summary = "查询上次发布信息")
    public ResultDto<DeployBasicInfoResDto> queryLatestDeployInfo(String application){
        DeployBasicInfoResDto res = deployService.queryLatestDeployInfo(application);
        return ResultDto.createSuccess(res);
    }

    @GetMapping("/releasePipeline/queryTenantPipeline")
    public JSONObject queryTenantPipeline(String application){
        String res="{\n" +
                "    \"code\": 0,\n" +
                "    \"msg\": null,\n" +
                "    \"data\": {\n" +
                "        \"createBy\": \"fujb@digiwin.com\",\n" +
                "        \"createDate\": \"2025-03-24T09:50:52.133+0000\",\n" +
                "        \"editBy\": \"nift@digiwin.com\",\n" +
                "        \"editDate\": \"2025-04-01T09:30:15.686+0000\",\n" +
                "        \"objectId\": \"67e12afc75444466e4adde09\",\n" +
                "        \"tenantId\": \"athenaPaaSDesigner\",\n" +
                "        \"groups\": [\n" +
                "            {\n" +
                "                \"groupName\": \"\",\n" +
                "                \"node\": {\n" +
                "                    \"serviceId\": \"HuaweiTest\",\n" +
                "                    \"serviceName\": \"大陆测试区\",\n" +
                "                    \"envs\": [\n" +
                "                        {\n" +
                "                            \"env\": \"HuaweiTest-TEST\",\n" +
                "                            \"operate\": \"publish\",\n" +
                "                            \"disable\": false,\n" +
                "                            \"url\": \"https://athena-deployer-service-test.apps.digiwincloud.com.cn\",\n" +
                "                            \"visible\": true\n" +
                "                        },\n" +
                "                        {\n" +
                "                            \"env\": \"HuaweiTest-PROD\",\n" +
                "                            \"operate\": \"switch\",\n" +
                "                            \"disable\": false,\n" +
                "                            \"url\": \"https://athena-deployer-service-test.apps.digiwincloud.com.cn\",\n" +
                "                            \"visible\": true\n" +
                "                        }\n" +
                "                    ],\n" +
                "                    \"children\": [],\n" +
                "                    \"friendlyLinkList\": [],\n" +
                "                    \"lang\": {\n" +
                "                        \"serviceName\": {\n" +
                "                            \"zh_CN\": \"大陆测试区\",\n" +
                "                            \"zh_TW\": \"大陸測試區\",\n" +
                "                            \"en_US\": \"大陆测试区\"\n" +
                "                        }\n" +
                "                    },\n" +
                "                    \"anyEnv\": \"HuaweiTest-TEST\"\n" +
                "                }\n" +
                "            }\n" +
                "        ]\n" +
                "    }\n" +
                "}";

        return JSONObject.parseObject(res);
    }
}
