package com.digiwin.athena.domain;

import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
@Accessors(chain = true)
@Document("deployDetail")
public class DeployDetail {

    public static final String SUCCESS = "success";

    public static final String FAIL = "fail";

    public static final String WARN = "warn";

    public static final String START = "start";

    public static final String FINISH = "finish";

    public static final String WAITING = "waiting";

    public static final String EXECUTING = "executing";

    @Id
    private String objectId;

    private String adpApplication;

    private String deployNo;

    private List<DetailContent> contents = new ArrayList<>();

    private String createBy;
    private Date createDate;
    private String editBy;
    private Date editDate;

    @Data
    @JsonInclude(JsonInclude.Include.ALWAYS)
    public static class DetailContent{
        private String content;
        private String result;
        private Date time;

        private String className;

        private Long executeTimeMills;

        private String errorMessage;

        private Object errorStack;

        private String cause;

        private String failMessage;

        private Object executeContent;
        private Map<String, MultiLanguageDTO> lang;

        //这个字段没有用，完全是为了兼容前端
        private Integer waitNum;
    }
}
