/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao;

import com.digiwin.athena.domain.DeployDetail;
import com.digiwin.athena.mongodb.repository.MongoPrimaryRepositoryDecorator;
import jakarta.annotation.Resource;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;

@Repository
public class DeployDetailMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployDetailMongoDao.class);
    @Resource
    private MongoPrimaryRepositoryDecorator mongoPrimaryRepositoryDecorator;

    public void updatePushContent(String deployNo, String application, DeployDetail.DetailContent detailContent) {
        Criteria criteria = Criteria.where((String)"deployNo").is((Object)deployNo).and("adpApplication").is((Object)application);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update().push("contents", (Object)detailContent);
        this.mongoPrimaryRepositoryDecorator.updateFirst(query, update, DeployDetail.class);
    }

    public void batchUpdatePushContent(List<String> deployNos, String application, DeployDetail.DetailContent detailContent) {
        Criteria criteria = Criteria.where((String)"deployNo").in(deployNos).and("adpApplication").is((Object)application);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update().push("contents", (Object)detailContent);
        this.mongoPrimaryRepositoryDecorator.updateMulti(query, update, DeployDetail.class);
    }

    public void insert(DeployDetail deployDetail) {
        this.mongoPrimaryRepositoryDecorator.insert((Object)deployDetail);
    }

    public DeployDetail selectByDeployNoAndApp(String deployNo, String application) {
        Criteria criteria = Criteria.where((String)"deployNo").is((Object)deployNo).and("adpApplication").is((Object)application);
        Query query = new Query((CriteriaDefinition)criteria);
        return (DeployDetail)this.mongoPrimaryRepositoryDecorator.findOne(query, DeployDetail.class);
    }
}

