package com.digiwin.athena.dao;

import com.digiwin.athena.domain.DeployDetail;
import com.digiwin.athena.mongodb.repository.MongoPrimaryRepositoryDecorator;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;

import java.util.List;

@Slf4j
@Repository
public class DeployDetailMongoDao {

    @Resource
    private MongoPrimaryRepositoryDecorator mongoPrimaryRepositoryDecorator;

    public void updatePushContent(String deployNo,String application, DeployDetail.DetailContent detailContent) {
        Criteria criteria = Criteria.where("deployNo").is(deployNo).and("adpApplication").is(application);
        Query query = new Query(criteria);

        Update update = new Update().push("contents", detailContent);

        mongoPrimaryRepositoryDecorator.updateFirst(query, update, DeployDetail.class);
    }

    public void batchUpdatePushContent(List<String> deployNos, String application, DeployDetail.DetailContent detailContent){
        Criteria criteria = Criteria.where("deployNo").in(deployNos).and("adpApplication").is(application);
        Query query = new Query(criteria);

        Update update = new Update().push("contents", detailContent);

        mongoPrimaryRepositoryDecorator.updateMulti(query, update, DeployDetail.class);
    }

    public void insert(DeployDetail deployDetail) {
        mongoPrimaryRepositoryDecorator.insert(deployDetail);
    }

    public DeployDetail selectByDeployNoAndApp(String deployNo, String application) {
        Criteria criteria = Criteria.where("deployNo").is(deployNo).and("adpApplication").is(application);
        Query query = new Query(criteria);

        return mongoPrimaryRepositoryDecorator.findOne(query, DeployDetail.class);
    }
}
