package com.digiwin.athena.dao;

import com.digiwin.athena.domain.DeployLog;
import com.digiwin.athena.mongodb.repository.MongoPrimaryRepositoryDecorator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.List;

@Slf4j
@Repository
public class DeployLogMongoDao {

    @Autowired
    private MongoPrimaryRepositoryDecorator mongoPrimaryRepositoryDecorator;
    public void insert(DeployLog deployLog) {
        mongoPrimaryRepositoryDecorator.insert(deployLog);
    }

    public void save(DeployLog deployLog) {
        mongoPrimaryRepositoryDecorator.save(deployLog);
    }

    public void updateProcess(BigDecimal process, String deployNo) {
        Criteria criteria = Criteria.where("deployNo").is(deployNo);
        Update update = new Update().set("process", process);
        mongoPrimaryRepositoryDecorator.updateFirst(new Query(criteria),update,DeployLog.class);
    }

    public void updateResult(String result, String deployNo) {
        Criteria criteria = Criteria.where("deployNo").is(deployNo);
        Update update = new Update().set("result", result);
        mongoPrimaryRepositoryDecorator.updateFirst(new Query(criteria),update,DeployLog.class);
    }

    public void updateProcessAndResult(BigDecimal process, String result, String deployNo) {
        Criteria criteria = Criteria.where("deployNo").is(deployNo);
        Update update = new Update()
                .set("process", process)
                .set("result",result);
        mongoPrimaryRepositoryDecorator.updateFirst(new Query(criteria),update,DeployLog.class);
    }

    public void updateFailByApplicationAndResult(String application, List<String> results) {
        Criteria criteria = Criteria.where("application").is(application)
                .and("result").in(results);

        Update update = new Update()
                .set("result", DeployLog.FAIL)
                .set("process", -1);
        mongoPrimaryRepositoryDecorator.updateMulti(new Query(criteria),update,DeployLog.class);
    }

    public List<DeployLog> selectByAppAndResult(String application, List<String> results) {
        Criteria criteria = Criteria.where("application").is(application)
                .and("result").in(results);
        return mongoPrimaryRepositoryDecorator.find(new Query(criteria),DeployLog.class);
    }

    public DeployLog selectByDeployNoAndApp(String deployNo, String application) {
        Criteria criteria = Criteria.where("deployNo").is(deployNo)
                .and("application").is(application);
        return mongoPrimaryRepositoryDecorator.findOne(new Query(criteria),DeployLog.class);
    }

    public DeployLog selectSuccessOneByApplication(String application) {
        Criteria criteria = Criteria.where("application").is(application).and("result").is(DeployLog.SUCCESS);
        Query query = new Query(criteria);
        query.with(Sort.by(Sort.Direction.DESC,"_id"));
        query.limit(1);
        return mongoPrimaryRepositoryDecorator.findOne(query,DeployLog.class);
    }

    public DeployLog selectLastOne(String application) {
        Query query = new Query(Criteria.where("application").is(application));
        query.with(Sort.by(Sort.Direction.DESC,"_id"));
        query.limit(1);
        return mongoPrimaryRepositoryDecorator.findOne(query,DeployLog.class);
    }
}
