package com.digiwin.athena.dto;

import com.digiwin.athena.domain.CompiledData;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.user.UserHelper;
import jakarta.validation.constraints.NotBlank;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * @author liyuetao
 * @title: CompileParam
 * @projectName athena_designer
 * @description: TODO
 * @date 2022/9/214:45
 */
@Data
@Accessors(chain = true)
public class CompileParam {
    @NotBlank
    private String application;
    @NotBlank
    private String branch;
    @NotBlank
    private String version;

    private List<String> versionNum;

    private String versionLetter;

    private String description;
    // 当前用户的token，模型驱动组入参需要
    private String token;

    private String module;

    public CompiledData createCompiledData() {
        CompiledData compiledData = new CompiledData();

        compiledData.setVersion(version);
        compiledData.setVersionNum(versionNum);
        compiledData.setVersionLetter(versionLetter);
        compiledData.setApplication(application);
        compiledData.setDescription(description);
        compiledData.setAllowCustomPublish(true);
        compiledData.setBranch(CurThreadInfoUtils.getBranchKey());
        UserHelper.fillCreateInfo(compiledData);
        UserHelper.fillEditInfo(compiledData);

        return compiledData;
    }
}
