package com.digiwin.athena.dto;

import com.digiwin.athena.domain.CompiledData;
import com.digiwin.athena.domain.DeployLog;
import lombok.Data;

import java.util.Date;

@Data
public class DeployBasicInfoResDto {

    private String  deployNo;
    private Date deployTime;
    private String  description;
    private String  version;

    private UserInfoDto user;

    public static DeployBasicInfoResDto create(DeployLog deployLog) {
        DeployBasicInfoResDto deployBasicInfoResDto = new DeployBasicInfoResDto();
        deployBasicInfoResDto.setDeployNo(deployLog.getDeployNo());
        deployBasicInfoResDto.setDeployTime(deployLog.getCreateDate());
        deployBasicInfoResDto.setUser(deployLog.getUser());

        CompiledData compileData = deployLog.getCompileData();
        if (compileData!=null) {
            deployBasicInfoResDto.setDescription(compileData.getDescription());
            deployBasicInfoResDto.setVersion(compileData.getVersion());
        }

        return deployBasicInfoResDto;
    }
}
