package com.digiwin.athena.dao;

import com.digiwin.athena.domain.DeployParamRecord;
import com.digiwin.athena.mongodb.repository.MongoPrimaryRepositoryDecorator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Slf4j
@Repository
public class DeployParamRecordMongoDao {
    @Autowired
    private MongoPrimaryRepositoryDecorator mongoPrimaryRepositoryDecorator;


    public DeployParamRecord selectByApplicationAndType(String adpApplication, String type) {
        Criteria criteria = Criteria.where("adpApplication").is(adpApplication).and("type").is(type);

        return mongoPrimaryRepositoryDecorator.findOne(new Query(criteria), DeployParamRecord.class);
    }

    public void insert(DeployParamRecord deployParamRecord) {
        mongoPrimaryRepositoryDecorator.insert(deployParamRecord);
    }

    public void save(DeployParamRecord deployParamRecord) {
        mongoPrimaryRepositoryDecorator.save(deployParamRecord);
    }
}
