/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.controller;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dto.AppCompileDataResult;
import com.digiwin.athena.dto.CompileParam;
import com.digiwin.athena.dto.DeployBasicInfoResDto;
import com.digiwin.athena.dto.DeployDataDto;
import com.digiwin.athena.dto.DeployDetailInfoResDto;
import com.digiwin.athena.dto.DeployLogParamDto;
import com.digiwin.athena.dto.DeployLogResDto;
import com.digiwin.athena.dto.DeployParam;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.publish.Publish;
import com.digiwin.athena.service.DeployService;
import com.digiwin.athena.utils.GzipUtil;
import com.digiwin.athena.utils.SwitchDatabaseUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/deploy"})
@Tag(name="\u53d1\u7248", description="58267dc0-83f4-48b0-86e2-8f1a3ebd08d7")
public class DeployController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployController.class);
    @Autowired
    private DeployService deployService;
    @Autowired
    private List<Publish> publishes;

    @PostMapping(value={"/addDeployPlan"})
    @Operation(summary="\u6dfb\u52a0\u53d1\u7248\u4efb\u52a1")
    public ResultDto<String> addDeployPlan(@RequestBody DeployParam deployParam) {
        String deployNo = this.deployService.addDeployPlan(deployParam);
        return ResultDto.createSuccess((Object)deployNo);
    }

    @PostMapping(value={"/compile"})
    @Operation(summary="\u5e94\u7528\u7f16\u8bd1")
    public ResultDto<String> compile(@RequestBody CompileParam compileParam) {
        String compiledCode = (String)SwitchDatabaseUtils.switchBranchDatabase((String)compileParam.getBranch(), () -> this.deployService.compile(compileParam));
        return ResultDto.createSuccess((Object)compiledCode);
    }

    @PostMapping(value={"/queryCompileData"})
    @Operation(summary="\u67e5\u8be2\u7f16\u8bd1\u7248\u672c")
    public ResultDto<List<AppCompileDataResult>> queryCompileData(@RequestBody List<String> applicationList) {
        List<AppCompileDataResult> result = this.deployService.queryCompileData(applicationList);
        return ResultDto.createSuccess(result);
    }

    @GetMapping(value={"/queryDeployDetailByApplication"})
    @Operation(summary="\u67e5\u8be2\u53d1\u5e03\u65e5\u5fd7")
    public ResultDto<DeployDetailInfoResDto> queryDeployDetail(@RequestParam(value="deployNo") String deployNo, @RequestParam(value="application") String application) {
        DeployDetailInfoResDto deployDetailInfoResDto = this.deployService.queryDeployDetail(deployNo, application);
        return ResultDto.createSuccess((Object)deployDetailInfoResDto);
    }

    @PostMapping(value={"/releasePipeline/queryDeployLogByEnv"})
    @Operation(summary="\u67e5\u8be2\u4e0a\u6b21\u53d1\u5e03\u6210\u529f\u8bb0\u5f55")
    public ResultDto<List<DeployLogResDto>> queryDeployLogByEnv(@RequestBody DeployLogParamDto deployLogParamDto) {
        List<DeployLogResDto> res = this.deployService.queryDeployLogByEnv(deployLogParamDto);
        return ResultDto.createSuccess(res);
    }

    @PostMapping(value={"/modulePublish"})
    public ResultDto<?> modulePublish(@RequestBody DeployDataDto deployDataDto) throws IOException {
        for (Publish publish : this.publishes) {
            String simpleName = AopUtils.getTargetClass((Object)publish).getSimpleName();
            if (!deployDataDto.getModuleType().equals(simpleName)) continue;
            List list = publish.jsonStrToObject((String)JSONObject.parseObject((String)new String(GzipUtil.decompress((byte[])deployDataDto.getZipData())), String.class));
            deployDataDto.setPublishData(list);
            publish.publishAll(deployDataDto);
        }
        return ResultDto.createSuccess(null);
    }

    @GetMapping(value={"/releasePipeline/queryLatestDeployInfo"})
    @Operation(summary="\u67e5\u8be2\u4e0a\u6b21\u53d1\u5e03\u4fe1\u606f")
    public ResultDto<DeployBasicInfoResDto> queryLatestDeployInfo(String application) {
        DeployBasicInfoResDto res = this.deployService.queryLatestDeployInfo(application);
        return ResultDto.createSuccess((Object)res);
    }

    @GetMapping(value={"/releasePipeline/queryTenantPipeline"})
    public JSONObject queryTenantPipeline(String application) {
        String res = "{\n    \"code\": 0,\n    \"msg\": null,\n    \"data\": {\n        \"createBy\": \"fujb@digiwin.com\",\n        \"createDate\": \"2025-03-24T09:50:52.133+0000\",\n        \"editBy\": \"nift@digiwin.com\",\n        \"editDate\": \"2025-04-01T09:30:15.686+0000\",\n        \"objectId\": \"67e12afc75444466e4adde09\",\n        \"tenantId\": \"athenaPaaSDesigner\",\n        \"groups\": [\n            {\n                \"groupName\": \"\",\n                \"node\": {\n                    \"serviceId\": \"HuaweiTest\",\n                    \"serviceName\": \"\u5927\u9646\u6d4b\u8bd5\u533a\",\n                    \"envs\": [\n                        {\n                            \"env\": \"HuaweiTest-TEST\",\n                            \"operate\": \"publish\",\n                            \"disable\": false,\n                            \"url\": \"https://athena-deployer-service-test.apps.digiwincloud.com.cn\",\n                            \"visible\": true\n                        },\n                        {\n                            \"env\": \"HuaweiTest-PROD\",\n                            \"operate\": \"switch\",\n                            \"disable\": false,\n                            \"url\": \"https://athena-deployer-service-test.apps.digiwincloud.com.cn\",\n                            \"visible\": true\n                        }\n                    ],\n                    \"children\": [],\n                    \"friendlyLinkList\": [],\n                    \"lang\": {\n                        \"serviceName\": {\n                            \"zh_CN\": \"\u5927\u9646\u6d4b\u8bd5\u533a\",\n                            \"zh_TW\": \"\u5927\u9678\u6e2c\u8a66\u5340\",\n                            \"en_US\": \"\u5927\u9646\u6d4b\u8bd5\u533a\"\n                        }\n                    },\n                    \"anyEnv\": \"HuaweiTest-TEST\"\n                }\n            }\n        ]\n    }\n}";
        return JSONObject.parseObject((String)res);
    }
}

