package com.digiwin.athena.http.asset;


import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.http.distribution.FxPageResDto;
import com.digiwin.athena.http.distribution.FxResponseDto;
import com.digiwin.athena.http.distribution.FxUserResDto;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;
import java.util.Map;

@Component
@Slf4j
public class ThirdPartyApiHelper {

    @Resource(name = "httpRestTemplate")
    private RestTemplate restTemplate;
    public PermissionConditionResDto getRowDataPermission(DataPermissionRequestInfoDto requestInfoDto,String token){
        if (StringUtils.isEmpty(requestInfoDto.getUrl())){
            return null;
        }

        String url = requestInfoDto.getUrl();
        JSONObject param = new JSONObject();

        JSONObject headerParam = requestInfoDto.getHeaders();
        HttpHeaders headers = new HttpHeaders();

        if (headerParam!=null){
            for (Map.Entry<String, Object> entry : headerParam.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue().toString();

                if (value.contains(DataPermissionRequestInfoDto.HEADER_PLACEHOLDER_IAM_TOKEN)){
                    String v = value.replace(DataPermissionRequestInfoDto.HEADER_PLACEHOLDER_IAM_TOKEN, token);
                    headers.set(key, v);
                }else{
                    headers.set(key, value);
                }
            }
        }

        HttpEntity<JSONObject> httpEntity = new HttpEntity<>(param, headers);

        ResponseEntity<String> response = restTemplate.postForEntity(url, httpEntity, String.class);
        String responseBody = response.getBody();
        if (!StringUtils.isEmpty(requestInfoDto.getResponseScript())){
            JSONObject res = (JSONObject) JSONPath.read(responseBody, requestInfoDto.getResponseScript());
            if (res == null){
                return null;
            }
            return res.toJavaObject(PermissionConditionResDto.class);
        }
        return null;
    }

}
