package com.digiwin.athena.http.distribution;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.base.ErrorCodeConstants;
import com.digiwin.athena.config.ModuleConfig;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import jakarta.annotation.Resource;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import java.io.File;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 分销api
 */
@Component
@Slf4j
public class FxApiHelper {
    public static final String PROGRAM_CODE = "lowcode";

    @Autowired
    private ModuleConfig moduleConfig;

    @Resource(name = "httpRestTemplate")
    RestTemplate restTemplate;
    public UploadFileResDto upload(UploadParamDto uploadParamDto){
        String url = moduleConfig.getFx().getDomain()+"/I/IERPRequestService/erpUpload";

        MultiValueMap<String, Object> body = new LinkedMultiValueMap<>();

        body.add("attach", uploadParamDto.getAttach());
        body.add("programCode", PROGRAM_CODE);
        body.add("tableNo", uploadParamDto.getTableNo());
        body.add("documentNo", uploadParamDto.getDocumentNo());

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        headers.set("token", CurThreadInfoUtils.getToken());

        HttpEntity<MultiValueMap<String, Object>> requestEntity = new HttpEntity<>(body, headers);

        // 发送 POST 请求
        ResponseEntity<String> response = restTemplate.postForEntity(url, requestEntity, String.class);
        String responseBody = response.getBody();
        FxResultDto<UploadFileResDto> fxResultDto = JSONObject.parseObject(responseBody, new TypeReference<FxResultDto<UploadFileResDto>>(){});

        Execution execution = fxResultDto.getStdData().getExecution();
        if (!execution.getCode().equals(0)){
            throw new RuntimeException(execution.getDescription());
        }
        Parameter<UploadFileResDto> parameter = fxResultDto.getStdData().getParameter();
        UploadFileResDto data = parameter.getData();
        return data;
    }

    public UploadFileResDto fxUploadFile(UploadParamDto uploadParamDto){
        String url = moduleConfig.getFx().getDomain()+"/A/IAttachFileService/uploadFile";

        MultiValueMap<String, Object> body = new LinkedMultiValueMap<>();

        body.add("attach", uploadParamDto.getAttach());

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        headers.set("token", CurThreadInfoUtils.getToken());
        headers.set("program-code", uploadParamDto.getProgramCode());

        HttpEntity<MultiValueMap<String, Object>> requestEntity = new HttpEntity<>(body, headers);

        // 发送 POST 请求
        ResponseEntity<String> response = restTemplate.postForEntity(url, requestEntity, String.class);
        String responseBody = response.getBody();
        FxResponseDto<List<UploadFileResDto>> fxResultDto = JSONObject.parseObject(responseBody, new TypeReference<>() {
        });
        FxResponseDto.Response<List<UploadFileResDto>> dtoResponse = fxResultDto.getResponse();

        if (!dtoResponse.getSuccessValue()){
            throw new RuntimeException(dtoResponse.getDescription());
        }
        UploadFileResDto uploadFileResDto = dtoResponse.getData().get(0);
        return uploadFileResDto;
    }

    @SneakyThrows
    public UploadFileResDto uploadFile(UploadParamDto uploadParamDto){
        File file = uploadParamDto.getFile();
        ByteArrayResource resource = new ByteArrayResource(Files.readAllBytes(file.toPath())) {
            @Override
            public String getFilename() {
                return file.getName();
            }
        };
        uploadParamDto.setAttach(resource);
        return upload(uploadParamDto);
    }


    public List<FxUserResDto> findFxUser(QueryFxUserReqDto queryFxUserReqDto){
        String url = moduleConfig.getFx().getDomain()+"/A/IFxai025Service/getList";
        JSONObject param = new JSONObject();
        param.put("queryInfo",queryFxUserReqDto);

        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        HttpEntity<JSONObject> httpEntity = new HttpEntity<>(param, headers);

        ResponseEntity<String> response = restTemplate.postForEntity(url, httpEntity, String.class);
        String responseBody = response.getBody();
        FxResponseDto<FxPageResDto<List<FxUserResDto>>> fxUserResDtoFxResponseDto = JSONObject.parseObject(responseBody, new TypeReference<FxResponseDto<FxPageResDto<List<FxUserResDto>>>>() {
        });
        if (!fxUserResDtoFxResponseDto.getStatus().equals(200)){
            throw new RuntimeException("查询分销用户失败");
        }
        return fxUserResDtoFxResponseDto.getResponse().getData().getDatas();
    }

    /**
     * 获取系统变量
     * @return
     */
    public JSONArray getSysEnum(){
        String url = moduleConfig.getFx().getDomain()+"/A/IACommonService/getSysEnum";

        JSONObject param = new JSONObject();
        param.put("param",new JSONObject());

        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        HttpEntity<JSONObject> httpEntity = new HttpEntity<>(param, headers);

        ResponseEntity<String> response = restTemplate.postForEntity(url, httpEntity, String.class);
        String responseBody = response.getBody();
        JSONObject jsonObject = JSONObject.parseObject(responseBody);
        if (jsonObject.getInteger("status")!=200){
            throw new RuntimeException("查询分销变量失败");
        }
        JSONObject responseJo = jsonObject.getJSONObject("response");
        return responseJo.getJSONArray("data");
    }

    /**
     * 向分销注册作业菜单
     * @param registerFxJobReqDto
     * @return
     */
    public Boolean registerJob(RegisterFxJobReqDto registerFxJobReqDto){
        String url = moduleConfig.getFx().getDomain()+"/A/IFxai006Service/addProgramData";
        JSONObject param = new JSONObject();
        param.put("param", registerFxJobReqDto);


        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        HttpEntity<JSONObject> httpEntity = new HttpEntity<>(param, headers);

        ResponseEntity<String> response = restTemplate.postForEntity(url, httpEntity, String.class);
        String responseBody = response.getBody();
        FxResponseDto fxResponseDto = JSONObject.parseObject(responseBody, new TypeReference<FxResponseDto>() {
        });
        FxResponseDto.Response fxResponse = fxResponseDto.getResponse();
        if (!fxResponse.getSuccess()) {
            log.error("注册作业失败" + responseBody);
            throw new RuntimeException("注册作业失败:"+JSONObject.toJSONString(fxResponse));
        }

        return true;
    }


    /**
     * 删除分销注册的作业
     * @param deleteFxJobReqDto
     * @return
     */
    public Boolean deleteJob(List<DeleteFxJobReqDto> deleteFxJobReqDtos){
        String url = moduleConfig.getFx().getDomain()+"/A/IFxai006Service/deleteData";
        JSONObject param = new JSONObject();
        param.put("param", deleteFxJobReqDtos);


        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        headers.set("program-code","fxai006");
        HttpEntity<JSONObject> httpEntity = new HttpEntity<>(param, headers);

        ResponseEntity<String> response = restTemplate.postForEntity(url, httpEntity, String.class);
        String responseBody = response.getBody();
        FxResponseDto fxResponseDto = JSONObject.parseObject(responseBody, new TypeReference<FxResponseDto>() {
        });
        FxResponseDto.Response fxResponse = fxResponseDto.getResponse();
        if (!fxResponse.getSuccess()) {
            log.error("删除注册作业失败" + responseBody);
            throw new RuntimeException("删除注册作业失败:"+JSONObject.toJSONString(fxResponse));
        }

        return true;
    }

    /**
     * 查询注册作业
     * @return
     */
    public List<FxRegisterJobInfoResDto> getJobList(GetFxJobListReqDto getFxJobListReqDto){
        String url = moduleConfig.getFx().getDomain()+"/A/IFxai006Service/getList";
        JSONObject param = new JSONObject();
        param.put("queryInfo", getFxJobListReqDto);

        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        headers.set("program-code","fxai006");
        HttpEntity<JSONObject> httpEntity = new HttpEntity<>(param, headers);

        ResponseEntity<String> response = restTemplate.postForEntity(url, httpEntity, String.class);
        String responseBody = response.getBody();
        FxResponseDto<FxPageResDto<List<FxRegisterJobInfoResDto>>> fxResponseDto = JSONObject.parseObject(responseBody, new TypeReference<FxResponseDto<FxPageResDto<List<FxRegisterJobInfoResDto>>>>() {
        });
        FxResponseDto.Response fxResponse = fxResponseDto.getResponse();
        if (!fxResponse.getSuccess()) {
            log.error("查询注册作业失败" + responseBody);
            throw new RuntimeException("查询注册作业失败:"+JSONObject.toJSONString(fxResponse));
        }
        return fxResponseDto.getResponse().getData().getDatas();
    }

    public FxRegisterJobDetailDto getJobDetailInfo(Map<String,String> searchFieldValue){
        String url = moduleConfig.getFx().getDomain()+"/A/IFxai006Service/getDetailInfo";
        JSONObject param = new JSONObject();
        param.put("param", searchFieldValue);

        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        HttpEntity<JSONObject> httpEntity = new HttpEntity<>(param, headers);

        ResponseEntity<String> response = restTemplate.postForEntity(url, httpEntity, String.class);
        String responseBody = response.getBody();
        FxResponseDto<FxRegisterJobDetailDto> fxResponseDto = JSONObject.parseObject(responseBody, new TypeReference<FxResponseDto<FxRegisterJobDetailDto>>() {
        });
        FxResponseDto.Response fxResponse = fxResponseDto.getResponse();
        if (!fxResponse.getSuccess()) {
            log.error("查询注册作业失败" + responseBody);
            throw new RuntimeException("查询注册作业失败:"+JSONObject.toJSONString(fxResponse));
        }
        return fxResponseDto.getResponse().getData();

    }

    public void updateJobInfo(FxRegisterJobDetailDto  fxRegisterJobDetailDto){
        String url = moduleConfig.getFx().getDomain()+"/A/IFxai006Service/updateProgramData";
        JSONObject param = new JSONObject();
        param.put("param", fxRegisterJobDetailDto);

        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        headers.set("program-code","fxai006");
        HttpEntity<JSONObject> httpEntity = new HttpEntity<>(param, headers);

        ResponseEntity<String> response = restTemplate.postForEntity(url, httpEntity, String.class);
        String responseBody = response.getBody();
        FxResponseDto fxResponseDto = JSONObject.parseObject(responseBody, new TypeReference<FxResponseDto>() {
        });
        FxResponseDto.Response fxResponse = fxResponseDto.getResponse();
        if (!fxResponse.getSuccess()) {
            log.error("修改注册作业失败" + responseBody);
            throw new RuntimeException("修改注册作业失败:"+JSONObject.toJSONString(fxResponse));
        }

    }

    /**
     * 查询作业权限
     *
     * @param programCode 作业编号
     * @return 权限信息
     */
    public ProgramAuthResDto getProgramAuth(String programCode) {
        String url = moduleConfig.getFx().getDomain() + "/A/IACommonService/getProgramAuth";

        ProgramAuthReqDto requestDto = new ProgramAuthReqDto();
        requestDto.setProgramCode(programCode);

        JSONObject param = new JSONObject();
        param.put("param", requestDto);

        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        HttpEntity<JSONObject> httpEntity = new HttpEntity<>(param, headers);

        ResponseEntity<String> response = restTemplate.postForEntity(url, httpEntity, String.class);
        String responseBody = response.getBody();
        FxResponseDto<ProgramAuthResDto> fxResponseDto = JSONObject.parseObject(responseBody, new TypeReference<>() {
        });
        FxResponseDto.Response<ProgramAuthResDto> fxResponse = Optional.ofNullable(fxResponseDto)
                .map(FxResponseDto::getResponse).orElse(null);
        if (fxResponse == null || !fxResponse.getSuccess()) {
            log.error("查询作业权限失败" + responseBody);
            throw new RuntimeException("查询作业权限失败:" + JSONObject.toJSONString(fxResponse));
        }
        return fxResponse.getData();
    }


    /**
     * 上传附件
     * @return
     */
    public FxUploadFileV3ResDto uploadFileV3(UploadFileV3ReqDto uploadFileV3ReqDto){

        String url = moduleConfig.getFx().getDomain() + "/A/ILowCodeService/uploadFile";

        MultiValueMap<String, Object> body = new LinkedMultiValueMap<>();

        body.add("fileItem", uploadFileV3ReqDto.getFileItem());
        body.add("fileName", uploadFileV3ReqDto.getFileName());
        body.add("componentId", uploadFileV3ReqDto.getComponentId());
        body.add("programId", uploadFileV3ReqDto.getProgramId());

        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        HttpEntity<MultiValueMap<String, Object>> httpEntity = new HttpEntity<>(body, headers);

        ResponseEntity<String> response = restTemplate.postForEntity(url, httpEntity, String.class);
        String responseBody = response.getBody();

        FxResponseDto<FxUploadFileV3ResDto> fxResponseDto = JSONObject.parseObject(responseBody, new TypeReference<FxResponseDto<FxUploadFileV3ResDto>>() {
        });
        FxResponseDto.Response<FxUploadFileV3ResDto> re = fxResponseDto.getResponse();
        if (!re.getSuccess()){
            log.error("上传附件异常："+responseBody);
            throw new RuntimeException("上传附件异常："+responseBody);
        }
        return re.getData();
    }

    /**
     * 发布同步文件
     * @return
     */
    public Boolean syncFileInfo(SyncFileInfoReqDto syncFileInfoReqDto){
        String url=moduleConfig.getFx().getDomain() +"/A/ILowCodeService/syncFileInfo";

        Map<String, Object> param = new HashMap<>();
        param.put("param",syncFileInfoReqDto);

        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        HttpEntity<Map<String, Object>> httpEntity = new HttpEntity<>(param, headers);

        ResponseEntity<String> response = restTemplate.postForEntity(url, httpEntity, String.class);
        String responseBody = response.getBody();
        FxResponseDto fxResponseDto = JSONObject.parseObject(responseBody, FxResponseDto.class);
        if (!fxResponseDto.getResponse().getSuccess()){
            log.error("syncFileInfo"+response);
            throw new BusinessException("分销同步文件异常");
        }
        return true;
    }

    /**
     * 查询上传的文件信息
     * @return
     */
    public List<FxUploadedFIleInfoV3ResDto> queryFileInfoByUUID(List<String> fileIds){
        String url=moduleConfig.getFx().getDomain() +"/A/ILowCodeService/queryFileInfoByUUID";

        Map<String, Object> params = new HashMap<>();
        params.put("fileIds",fileIds);

        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        HttpEntity<Map<String, Object>> httpEntity = new HttpEntity<>(params, headers);

        try {
            ResponseEntity<String> response = restTemplate.postForEntity(url, httpEntity, String.class);
            String body = response.getBody();
            FxResponseDto<List<FxUploadedFIleInfoV3ResDto>> res = JSONObject.parseObject(body,new TypeReference<FxResponseDto<List<FxUploadedFIleInfoV3ResDto>>>(){});
            return res.getResponse().getData();
        } catch (Exception e) {
            log.error("queryFileInfoByUUID 异常"+e.getMessage(),e);
            throw new BusinessException(ErrorCodeConstants.FX_REQUEST_EXCEPTION,
                    new Object[]{});
        }
    }
}
