package com.digiwin.athena.http.esp;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.config.ModuleConfig;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Component
@Slf4j
public class EspApiHelper {

    @Value("${rest-url.appToken}")
    private String appToken;

    @Autowired
    private ModuleConfig moduleConfig;

    public <T, R> EspParamDto<R> callEspService(T param, String espActionId, String token, String tenantId, String serviceCode) {
        // 组装导出模型sql的入参
        // 组装header
        Map<String, String> headers = new HashMap<>();
        headers.put("digi-middleware-auth-app", appToken);
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        headers.put("digi-type", "sync");

        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String formatTime = sdf.format(date);

        DigiHostDto digiHostDto = new DigiHostDto("Athena", "1.0", "zh_CN", formatTime, StringUtils.EMPTY, "athena", "athena");
        String digiHostStr = JSON.toJSONString(digiHostDto);
        headers.put("digi-host", digiHostStr);

        DigiServiceDto digiServiceDto = new DigiServiceDto(serviceCode, serviceCode, tenantId, espActionId);
        String digiServiceStr = JSON.toJSONString(digiServiceDto);
        headers.put("digi-service", digiServiceStr);

        // 组装请求体body
        EspParamDto espParamDto = new EspParamDto();
        EspParamDto.StdData<Object> stdData = new EspParamDto.StdData<>();

        stdData.setParameter(param);
        espParamDto.setStd_data(stdData);

        String requestJson = JSON.toJSONString(espParamDto);
        String fileMD5 = DigestUtils.md5Hex(digiHostStr + digiServiceStr);
        headers.put("digi-key", fileMD5);

        String url = moduleConfig.getEsp().getDomain() + "/CROSS/RESTful";
        String stdResponse = HttpUtil.createPost(url).body(requestJson).addHeaders(headers).execute().body();
        EspParamDto espRespParam = JSON.parseObject(stdResponse, new TypeReference<EspParamDto<R>>() {
        });
        EspParamDto.StdData stdDataResp = espRespParam.getStd_data();
        if (Objects.nonNull(stdDataResp)) {
            EspParamDto.Execution execution = stdDataResp.getExecution();

            if ("0".equals(execution.getCode())) {
                return espRespParam;
            } else {
                if ("-1".equals(execution.getCode())) {
                    String description = execution.getDescription();
                    throw new BusinessException(description);
                }
            }
        }
        throw new BusinessException(requestJson);
    }

}
