package com.digiwin.athena.http.iam.service.impl;

import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.http.iam.api.IamAppTokenApi;
import com.digiwin.athena.http.iam.dto.GetAppTokenReqDto;
import com.digiwin.athena.http.iam.dto.IamAppInfo;
import com.digiwin.athena.http.iam.dto.ResultDto;
import com.digiwin.athena.http.iam.service.AppTokenService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@RequiredArgsConstructor
@Service
public class IamAppTokenFacadeService implements AppTokenService {
    protected final IamAppTokenApi iamAppTokenApi;

    @Override
    public String findAppTokenByCode(String appToken, String token, String code) {
        ResultDto<IamAppInfo> appTokenResp = iamAppTokenApi.getAppToken(appToken, token, GetAppTokenReqDto.of(code));
        if (!appTokenResp.getSuccess() || appTokenResp.getData() == null) {
            log.error("获取应用token失败: {}", appTokenResp.getMessage());
            throw new BusinessException("获取应用token失败: " + appTokenResp.getMessage());
        }

        IamAppInfo data = appTokenResp.getData();

        return data.getAppToken();
    }

}
