package com.digiwin.athena.http.iam.api;

import com.digiwin.athena.http.iam.IamConstant;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;

import java.util.List;

@FeignClient(name = "cac-authorization-service",
        url = "${module.cac.domain:}", path = "/api/cac/v4/authorizations", primary = false)
public interface CacAuthorizationApi {

    @GetMapping("/tenants/{tenantId}/users/{userId}/enabled")
    List<String> getEnabledAppCodes(
            @RequestHeader(IamConstant.HEADER_APP) String appToken,
            @RequestHeader(IamConstant.HEADER_USER) String userToken,
            @PathVariable("tenantId") String tenantId,
            @PathVariable("userId") String userId
    );
}