package com.digiwin.athena.http.iam.service.impl;

import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.http.iam.api.CacAuthorizationApi;
import com.digiwin.athena.http.iam.service.CacAuthorizationService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@RequiredArgsConstructor
@Service
public class CacAuthorizationServiceImpl implements CacAuthorizationService {

    private final CacAuthorizationApi cacAuthorizationApi;

    @Override
    public List<String> authAppCodes(String appToken, String token, String userId, String tenantId) {
        try {
            List<String> res = cacAuthorizationApi.getEnabledAppCodes(appToken, token, tenantId, userId);
            return res;
        } catch (Exception e) {
            log.error("/api/cac/v4/authorizations/tenants/{}/users/{}/enabled异常：{}", tenantId, userId, e.getMessage());
            throw new BusinessException("cac接口请求异常");
        }
    }
}