/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.http.distribution;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.config.ModuleConfig;
import com.digiwin.athena.http.distribution.DeleteFxJobReqDto;
import com.digiwin.athena.http.distribution.Execution;
import com.digiwin.athena.http.distribution.FxPageResDto;
import com.digiwin.athena.http.distribution.FxRegisterJobDetailDto;
import com.digiwin.athena.http.distribution.FxRegisterJobInfoResDto;
import com.digiwin.athena.http.distribution.FxResponseDto;
import com.digiwin.athena.http.distribution.FxResultDto;
import com.digiwin.athena.http.distribution.FxUploadFileV3ResDto;
import com.digiwin.athena.http.distribution.FxUploadedFIleInfoV3ResDto;
import com.digiwin.athena.http.distribution.FxUserResDto;
import com.digiwin.athena.http.distribution.GetFxJobListReqDto;
import com.digiwin.athena.http.distribution.Parameter;
import com.digiwin.athena.http.distribution.ProgramAuthReqDto;
import com.digiwin.athena.http.distribution.ProgramAuthResDto;
import com.digiwin.athena.http.distribution.QueryFxUserReqDto;
import com.digiwin.athena.http.distribution.RegisterFxJobReqDto;
import com.digiwin.athena.http.distribution.SyncFileInfoReqDto;
import com.digiwin.athena.http.distribution.UploadFileResDto;
import com.digiwin.athena.http.distribution.UploadFileV3ReqDto;
import com.digiwin.athena.http.distribution.UploadParamDto;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import jakarta.annotation.Resource;
import java.io.File;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class FxApiHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FxApiHelper.class);
    public static final String PROGRAM_CODE = "lowcode";
    @Autowired
    private ModuleConfig moduleConfig;
    @Resource(name="httpRestTemplate")
    RestTemplate restTemplate;

    public UploadFileResDto upload(UploadParamDto uploadParamDto) {
        String url = this.moduleConfig.getFx().getDomain() + "/I/IERPRequestService/erpUpload";
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"attach", (Object)uploadParamDto.getAttach());
        body.add((Object)"programCode", (Object)PROGRAM_CODE);
        body.add((Object)"tableNo", (Object)uploadParamDto.getTableNo());
        body.add((Object)"documentNo", (Object)uploadParamDto.getDocumentNo());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        headers.set("token", CurThreadInfoUtils.getToken());
        HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        String responseBody = (String)response.getBody();
        FxResultDto fxResultDto = (FxResultDto)JSONObject.parseObject((String)responseBody, (TypeReference)new TypeReference<FxResultDto<UploadFileResDto>>(){}, (Feature[])new Feature[0]);
        Execution execution = fxResultDto.getStdData().getExecution();
        if (!execution.getCode().equals(0)) {
            throw new RuntimeException(execution.getDescription());
        }
        Parameter parameter = fxResultDto.getStdData().getParameter();
        UploadFileResDto data = (UploadFileResDto)parameter.getData();
        return data;
    }

    public UploadFileResDto fxUploadFile(UploadParamDto uploadParamDto) {
        String url = this.moduleConfig.getFx().getDomain() + "/A/IAttachFileService/uploadFile";
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"attach", (Object)uploadParamDto.getAttach());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        headers.set("token", CurThreadInfoUtils.getToken());
        headers.set("program-code", uploadParamDto.getProgramCode());
        HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        String responseBody = (String)response.getBody();
        FxResponseDto fxResultDto = (FxResponseDto)JSONObject.parseObject((String)responseBody, (TypeReference)new TypeReference<FxResponseDto<List<UploadFileResDto>>>(){}, (Feature[])new Feature[0]);
        FxResponseDto.Response dtoResponse = fxResultDto.getResponse();
        if (!dtoResponse.getSuccessValue().booleanValue()) {
            throw new RuntimeException(dtoResponse.getDescription());
        }
        UploadFileResDto uploadFileResDto = (UploadFileResDto)((List)dtoResponse.getData()).get(0);
        return uploadFileResDto;
    }

    public UploadFileResDto uploadFile(UploadParamDto uploadParamDto) {
        final File file = uploadParamDto.getFile();
        ByteArrayResource resource = new ByteArrayResource(Files.readAllBytes(file.toPath())){

            public String getFilename() {
                return file.getName();
            }
        };
        uploadParamDto.setAttach((org.springframework.core.io.Resource)resource);
        return this.upload(uploadParamDto);
    }

    public List<FxUserResDto> findFxUser(QueryFxUserReqDto queryFxUserReqDto) {
        String url = this.moduleConfig.getFx().getDomain() + "/A/IFxai025Service/getList";
        JSONObject param = new JSONObject();
        param.put("queryInfo", (Object)queryFxUserReqDto);
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        String responseBody = (String)response.getBody();
        FxResponseDto fxUserResDtoFxResponseDto = (FxResponseDto)JSONObject.parseObject((String)responseBody, (TypeReference)new TypeReference<FxResponseDto<FxPageResDto<List<FxUserResDto>>>>(){}, (Feature[])new Feature[0]);
        if (!fxUserResDtoFxResponseDto.getStatus().equals(200)) {
            throw new RuntimeException("\u67e5\u8be2\u5206\u9500\u7528\u6237\u5931\u8d25");
        }
        return (List)((FxPageResDto)fxUserResDtoFxResponseDto.getResponse().getData()).getDatas();
    }

    public JSONArray getSysEnum() {
        String url = this.moduleConfig.getFx().getDomain() + "/A/IACommonService/getSysEnum";
        JSONObject param = new JSONObject();
        param.put("param", (Object)new JSONObject());
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        String responseBody = (String)response.getBody();
        JSONObject jsonObject = JSONObject.parseObject((String)responseBody);
        if (jsonObject.getInteger("status") != 200) {
            throw new RuntimeException("\u67e5\u8be2\u5206\u9500\u53d8\u91cf\u5931\u8d25");
        }
        JSONObject responseJo = jsonObject.getJSONObject("response");
        return responseJo.getJSONArray("data");
    }

    public Boolean registerJob(RegisterFxJobReqDto registerFxJobReqDto) {
        String url = this.moduleConfig.getFx().getDomain() + "/A/IFxai006Service/addProgramData";
        JSONObject param = new JSONObject();
        param.put("param", (Object)registerFxJobReqDto);
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        String responseBody = (String)response.getBody();
        FxResponseDto fxResponseDto = (FxResponseDto)JSONObject.parseObject((String)responseBody, (TypeReference)new TypeReference<FxResponseDto>(){}, (Feature[])new Feature[0]);
        FxResponseDto.Response fxResponse = fxResponseDto.getResponse();
        if (!fxResponse.getSuccess().booleanValue()) {
            log.error("\u6ce8\u518c\u4f5c\u4e1a\u5931\u8d25" + responseBody);
            throw new RuntimeException("\u6ce8\u518c\u4f5c\u4e1a\u5931\u8d25:" + JSONObject.toJSONString(fxResponse));
        }
        return true;
    }

    public Boolean deleteJob(List<DeleteFxJobReqDto> deleteFxJobReqDtos) {
        String url = this.moduleConfig.getFx().getDomain() + "/A/IFxai006Service/deleteData";
        JSONObject param = new JSONObject();
        param.put("param", deleteFxJobReqDtos);
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        headers.set("program-code", "fxai006");
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        String responseBody = (String)response.getBody();
        FxResponseDto fxResponseDto = (FxResponseDto)JSONObject.parseObject((String)responseBody, (TypeReference)new TypeReference<FxResponseDto>(){}, (Feature[])new Feature[0]);
        FxResponseDto.Response fxResponse = fxResponseDto.getResponse();
        if (!fxResponse.getSuccess().booleanValue()) {
            log.error("\u5220\u9664\u6ce8\u518c\u4f5c\u4e1a\u5931\u8d25" + responseBody);
            throw new RuntimeException("\u5220\u9664\u6ce8\u518c\u4f5c\u4e1a\u5931\u8d25:" + JSONObject.toJSONString(fxResponse));
        }
        return true;
    }

    public List<FxRegisterJobInfoResDto> getJobList(GetFxJobListReqDto getFxJobListReqDto) {
        String url = this.moduleConfig.getFx().getDomain() + "/A/IFxai006Service/getList";
        JSONObject param = new JSONObject();
        param.put("queryInfo", (Object)getFxJobListReqDto);
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        headers.set("program-code", "fxai006");
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        String responseBody = (String)response.getBody();
        FxResponseDto fxResponseDto = (FxResponseDto)JSONObject.parseObject((String)responseBody, (TypeReference)new TypeReference<FxResponseDto<FxPageResDto<List<FxRegisterJobInfoResDto>>>>(){}, (Feature[])new Feature[0]);
        FxResponseDto.Response fxResponse = fxResponseDto.getResponse();
        if (!fxResponse.getSuccess().booleanValue()) {
            log.error("\u67e5\u8be2\u6ce8\u518c\u4f5c\u4e1a\u5931\u8d25" + responseBody);
            throw new RuntimeException("\u67e5\u8be2\u6ce8\u518c\u4f5c\u4e1a\u5931\u8d25:" + JSONObject.toJSONString(fxResponse));
        }
        return (List)((FxPageResDto)fxResponseDto.getResponse().getData()).getDatas();
    }

    public FxRegisterJobDetailDto getJobDetailInfo(Map<String, String> searchFieldValue) {
        String url = this.moduleConfig.getFx().getDomain() + "/A/IFxai006Service/getDetailInfo";
        JSONObject param = new JSONObject();
        param.put("param", searchFieldValue);
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        String responseBody = (String)response.getBody();
        FxResponseDto fxResponseDto = (FxResponseDto)JSONObject.parseObject((String)responseBody, (TypeReference)new TypeReference<FxResponseDto<FxRegisterJobDetailDto>>(){}, (Feature[])new Feature[0]);
        FxResponseDto.Response fxResponse = fxResponseDto.getResponse();
        if (!fxResponse.getSuccess().booleanValue()) {
            log.error("\u67e5\u8be2\u6ce8\u518c\u4f5c\u4e1a\u5931\u8d25" + responseBody);
            throw new RuntimeException("\u67e5\u8be2\u6ce8\u518c\u4f5c\u4e1a\u5931\u8d25:" + JSONObject.toJSONString(fxResponse));
        }
        return (FxRegisterJobDetailDto)fxResponseDto.getResponse().getData();
    }

    public void updateJobInfo(FxRegisterJobDetailDto fxRegisterJobDetailDto) {
        String url = this.moduleConfig.getFx().getDomain() + "/A/IFxai006Service/updateProgramData";
        JSONObject param = new JSONObject();
        param.put("param", (Object)fxRegisterJobDetailDto);
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        headers.set("program-code", "fxai006");
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        String responseBody = (String)response.getBody();
        FxResponseDto fxResponseDto = (FxResponseDto)JSONObject.parseObject((String)responseBody, (TypeReference)new TypeReference<FxResponseDto>(){}, (Feature[])new Feature[0]);
        FxResponseDto.Response fxResponse = fxResponseDto.getResponse();
        if (!fxResponse.getSuccess().booleanValue()) {
            log.error("\u4fee\u6539\u6ce8\u518c\u4f5c\u4e1a\u5931\u8d25" + responseBody);
            throw new RuntimeException("\u4fee\u6539\u6ce8\u518c\u4f5c\u4e1a\u5931\u8d25:" + JSONObject.toJSONString(fxResponse));
        }
    }

    public ProgramAuthResDto getProgramAuth(String programCode) {
        String url = this.moduleConfig.getFx().getDomain() + "/A/IACommonService/getProgramAuth";
        ProgramAuthReqDto requestDto = new ProgramAuthReqDto();
        requestDto.setProgramCode(programCode);
        JSONObject param = new JSONObject();
        param.put("param", (Object)requestDto);
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        String responseBody = (String)response.getBody();
        FxResponseDto fxResponseDto = (FxResponseDto)JSONObject.parseObject((String)responseBody, (TypeReference)new TypeReference<FxResponseDto<ProgramAuthResDto>>(){}, (Feature[])new Feature[0]);
        FxResponseDto.Response fxResponse = Optional.ofNullable(fxResponseDto).map(FxResponseDto::getResponse).orElse(null);
        if (fxResponse == null || !fxResponse.getSuccess().booleanValue()) {
            log.error("\u67e5\u8be2\u4f5c\u4e1a\u6743\u9650\u5931\u8d25" + responseBody);
            throw new RuntimeException("\u67e5\u8be2\u4f5c\u4e1a\u6743\u9650\u5931\u8d25:" + JSONObject.toJSONString((Object)fxResponse));
        }
        return (ProgramAuthResDto)fxResponse.getData();
    }

    public FxUploadFileV3ResDto uploadFileV3(UploadFileV3ReqDto uploadFileV3ReqDto) {
        String url = this.moduleConfig.getFx().getDomain() + "/A/ILowCodeService/uploadFile";
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"fileItem", (Object)uploadFileV3ReqDto.getFileItem());
        body.add((Object)"fileName", (Object)uploadFileV3ReqDto.getFileName());
        body.add((Object)"componentId", (Object)uploadFileV3ReqDto.getComponentId());
        body.add((Object)"programId", (Object)uploadFileV3ReqDto.getProgramId());
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        String responseBody = (String)response.getBody();
        FxResponseDto fxResponseDto = (FxResponseDto)JSONObject.parseObject((String)responseBody, (TypeReference)new TypeReference<FxResponseDto<FxUploadFileV3ResDto>>(){}, (Feature[])new Feature[0]);
        FxResponseDto.Response re = fxResponseDto.getResponse();
        if (!re.getSuccess().booleanValue()) {
            log.error("\u4e0a\u4f20\u9644\u4ef6\u5f02\u5e38\uff1a" + responseBody);
            throw new RuntimeException("\u4e0a\u4f20\u9644\u4ef6\u5f02\u5e38\uff1a" + responseBody);
        }
        return (FxUploadFileV3ResDto)re.getData();
    }

    public Boolean syncFileInfo(SyncFileInfoReqDto syncFileInfoReqDto) {
        String url = this.moduleConfig.getFx().getDomain() + "/A/ILowCodeService/syncFileInfo";
        HashMap<String, SyncFileInfoReqDto> param = new HashMap<String, SyncFileInfoReqDto>();
        param.put("param", syncFileInfoReqDto);
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        String responseBody = (String)response.getBody();
        FxResponseDto fxResponseDto = (FxResponseDto)JSONObject.parseObject((String)responseBody, FxResponseDto.class);
        if (!fxResponseDto.getResponse().getSuccess().booleanValue()) {
            log.error("syncFileInfo" + String.valueOf(response));
            throw new BusinessException("\u5206\u9500\u540c\u6b65\u6587\u4ef6\u5f02\u5e38");
        }
        return true;
    }

    public List<FxUploadedFIleInfoV3ResDto> queryFileInfoByUUID(List<String> fileIds) {
        String url = this.moduleConfig.getFx().getDomain() + "/A/ILowCodeService/queryFileInfoByUUID";
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("fileIds", fileIds);
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", CurThreadInfoUtils.getToken());
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
            String body = (String)response.getBody();
            FxResponseDto res = (FxResponseDto)JSONObject.parseObject((String)body, (TypeReference)new TypeReference<FxResponseDto<List<FxUploadedFIleInfoV3ResDto>>>(){}, (Feature[])new Feature[0]);
            return (List)res.getResponse().getData();
        }
        catch (Exception e) {
            log.error("queryFileInfoByUUID \u5f02\u5e38" + e.getMessage(), (Throwable)e);
            throw new BusinessException(Integer.valueOf(4005), new Object[0]);
        }
    }
}

