package com.digiwin.athena.http.iam.api;

import com.digiwin.athena.http.iam.IamConstant;
import com.digiwin.athena.http.iam.dto.IamUserPermissionDto;
import com.digiwin.athena.http.iam.dto.IamUserPermissionReqDto;
import com.digiwin.athena.http.iam.dto.ResultDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

import java.util.List;

@FeignClient(name = "iam-service",
        url = "${module.iam.domain:}", path = "/api/iam/v2/permission", primary = false)
public interface IamPermissionApi {

    @PostMapping("/user")
    ResultDto<List<IamUserPermissionDto>> fetchUserPermission(
            @RequestHeader(IamConstant.HEADER_APP) String appToken,
            @RequestHeader(IamConstant.HEADER_USER) String userToken,
            @RequestBody IamUserPermissionReqDto request
    );
}
