/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.http.esp;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.config.ModuleConfig;
import com.digiwin.athena.http.esp.DigiHostDto;
import com.digiwin.athena.http.esp.DigiServiceDto;
import com.digiwin.athena.http.esp.EspParamDto;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EspApiHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EspApiHelper.class);
    @Value(value="${rest-url.appToken}")
    private String appToken;
    @Autowired
    private ModuleConfig moduleConfig;

    public <T, R> EspParamDto<R> callEspService(T param, String espActionId, String token, String tenantId, String serviceCode) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("digi-middleware-auth-app", this.appToken);
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        headers.put("digi-type", "sync");
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String formatTime = sdf.format(date);
        DigiHostDto digiHostDto = new DigiHostDto("Athena", "1.0", "zh_CN", formatTime, "", "athena", "athena");
        String digiHostStr = JSON.toJSONString((Object)digiHostDto);
        headers.put("digi-host", digiHostStr);
        DigiServiceDto digiServiceDto = new DigiServiceDto(serviceCode, serviceCode, tenantId, espActionId);
        String digiServiceStr = JSON.toJSONString((Object)digiServiceDto);
        headers.put("digi-service", digiServiceStr);
        EspParamDto espParamDto = new EspParamDto();
        EspParamDto.StdData<T> stdData = new EspParamDto.StdData<T>();
        stdData.setParameter(param);
        espParamDto.setStd_data(stdData);
        String requestJson = JSON.toJSONString(espParamDto);
        String fileMD5 = DigestUtils.md5Hex((String)(digiHostStr + digiServiceStr));
        headers.put("digi-key", fileMD5);
        String url = this.moduleConfig.getEsp().getDomain() + "/CROSS/RESTful";
        String stdResponse = ((HttpRequest)HttpUtil.createPost((String)url).body(requestJson).addHeaders(headers)).execute().body();
        EspParamDto espRespParam = (EspParamDto)JSON.parseObject((String)stdResponse, (TypeReference)new TypeReference<EspParamDto<R>>(){}, (Feature[])new Feature[0]);
        EspParamDto.StdData stdDataResp = espRespParam.getStd_data();
        if (Objects.nonNull(stdDataResp)) {
            EspParamDto.Execution execution = stdDataResp.getExecution();
            if ("0".equals(execution.getCode())) {
                return espRespParam;
            }
            if ("-1".equals(execution.getCode())) {
                String description = execution.getDescription();
                throw new BusinessException(description);
            }
        }
        throw new BusinessException(requestJson);
    }
}

