package com.digiwin.athena.http.iam.api;

import com.digiwin.athena.http.iam.IamConstant;
import com.digiwin.athena.http.iam.dto.GetAppTokenReqDto;
import com.digiwin.athena.http.iam.dto.IamAppInfo;
import com.digiwin.athena.http.iam.dto.ResultDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

/**
 * IAM服务Feign客户端
 */
@FeignClient(name = "iam-app-token-service",
        url = "${module.iam.domain:}", path = "/api/iam/v2/dev/app", primary = false)
public interface IamAppTokenApi {

    /**
     * 获取IAM生成的应用的appToken
     *
     * @param appToken  应用认证token
     * @param userToken 用户认证token
     * @param request   请求参数
     * @return 应用信息
     */
    @PostMapping("/one")
    ResultDto<IamAppInfo> getAppToken(
            @RequestHeader(IamConstant.HEADER_APP) String appToken,
            @RequestHeader(IamConstant.HEADER_USER) String userToken,
            @RequestBody GetAppTokenReqDto request
    );
}
