package com.digiwin.athena.http.distribution;

import lombok.Data;

import java.util.List;

/**
 * 查询作业权限响应DTO
 */
@Data
public class ProgramAuthResDto {
    /**
     * 作业可访问
     */
    private Boolean accessible;

    /**
     * 权限内容
     */
    private List<AuthInfo> authInfo;

    @Data
    public static class AuthInfo {
        /**
         * 作业编号
         */
        private String code;

        /**
         * 权限动作列表
         */
        private List<Action> action;
    }

    @Data
    public static class Action {
        /**
         * 权限id
         */
        private String id;

        /**
         * 控制行为
         */
        private String restriction;
    }
}