package com.digiwin.athena.http.iam.dto;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;

public class IamAppInfo {
    /**
     * 用户sid
     */
    private String sid;
    /**
     * 用户ID
     */
    private String id;
    private String tenantSid;
    /**
     * 应用名称-简体 繁体 英文
     */
    private String nameCN;
    private String nameTW;
    private String nameUS;

    /**
     * 应用图标
     */
    private String logoImageUrl;

    /**
     * 应用类型
     */
    private String sysType;

    /**
     * 应用类别(0:Dap;1:Athena;2:其他)
     */
    private String sysCategory;
    private String appToken;
    private String appSecret;
    private String remarks;
    /**
     * 是否鼎捷内部应用，0-开发者门户创建应用，1-普通应用,2-自有应用
     */
    private String common;
    /**
     * 类型：Number 必有字段 备注：开发平台(0 Dap平台;1 低代码平台;2 其他)
     */
    private String devPlatform;
    /**
     * 开启权限管控
     */
    private String enableAuth;

    //前端是判斷應用的 onSale 這個字段來顯示「刪除」的功能，onSale = true 則「刪除」會被拿掉
    private Boolean onSale;

    private Boolean visible;

    private String createById;

    private String createDate;


    public String getCreateById() {
        return createById;
    }

    public void setCreateById(String createById) {
        this.createById = createById;
    }

    public String getCreateDate() {
        return createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public Boolean getOnSale() {
        return onSale;
    }

    public void setOnSale(Boolean onSale) {
        this.onSale = onSale;
    }

    public Boolean getVisible() {
        return visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public String getSid() {
          return sid;
     }

     public void setSid(String sid) {
          this.sid = sid;
     }

     public String getId() {
          return id;
     }

     public void setId(String id) {
          this.id = id;
     }

     public String getTenantSid() {
          return tenantSid;
     }

     public void setTenantSid(String tenantSid) {
          this.tenantSid = tenantSid;
     }

     public String getNameCN() {
          return nameCN;
     }

     public void setNameCN(String nameCN) {
          this.nameCN = nameCN;
     }

     public String getNameTW() {
          return nameTW;
     }

     public void setNameTW(String nameTW) {
          this.nameTW = nameTW;
     }

     public String getNameUS() {
          return nameUS;
     }

     public void setNameUS(String nameUS) {
          this.nameUS = nameUS;
     }

     public String getLogoImageUrl() {
          return logoImageUrl;
     }

     public void setLogoImageUrl(String logoImageUrl) {
          this.logoImageUrl = logoImageUrl;
     }

     public String getSysType() {
          return sysType;
     }

     public void setSysType(String sysType) {
          this.sysType = sysType;
     }

     public String getSysCategory() {
          return sysCategory;
     }

     public void setSysCategory(String sysCategory) {
          this.sysCategory = sysCategory;
     }

     public String getAppToken() {
          return appToken;
     }

     public void setAppToken(String appToken) {
          this.appToken = appToken;
     }

     public String getRemarks() {
          return remarks;
     }

     public void setRemarks(String remarks) {
          this.remarks = remarks;
     }

     public String getCommon() {
          return common;
     }

     public void setCommon(String common) {
          this.common = common;
     }

     public String getDevPlatform() {
          return devPlatform;
     }

     public void setDevPlatform(String devPlatform) {
          this.devPlatform = devPlatform;
     }

     public String getEnableAuth() {
          return enableAuth;
     }

     public void setEnableAuth(String enableAuth) {
          this.enableAuth = enableAuth;
     }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public static void main(String[] args) {
        String jsonString = "{\n" +
                "    \"code\": \"PR_6ce49942100026df\",\n" +
                "    \"pages\":\n" +
                "    {\n" +
                "        \"condition-detail\":\n" +
                "        {\n" +
                "            \"extendedFields\":\n" +
                "            {\n" +
                "                \"STATEMENT__resid_zh_TW\": \"EANA$2$17$1$22c9d07382d145b2be93ebe1180b617c$c999571fa1e7491f95ff804a1d59b498\"\n" +
                "            }\n" +
                "        }\n" +
                "    },\n" +
                "    \"name\": \"cxzc\",\n" +
                "    \"authorityPrefix\": \"\",\n" +
                "    \"dependOnGroundEnd\": false,\n" +
                "    \"pageFlag\": \"N\",\n" +
                "    \"application\": \"A20230514140739-lcdp\"\n" +
                "}";

        // 使用JSONPath表达式读取STATEMENT__resid_zh_TW的值
        JSONObject jsonObject = JSON.parseObject(jsonString);
        Object value = JSONPath.set(jsonObject, "$['pages']['condition-detail']['extendedFields']['STATEMENT__resid_zh_TW']","11");
        System.out.println( JSON.toJSONString(jsonObject));
    }
}
