/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.http.iam.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.http.iam.api.IamPermissionApi;
import com.digiwin.athena.http.iam.dto.ActionPermissionInfoResDto;
import com.digiwin.athena.http.iam.dto.IamUserPermissionDto;
import com.digiwin.athena.http.iam.dto.IamUserPermissionReqDto;
import com.digiwin.athena.http.iam.dto.ResultDto;
import com.digiwin.athena.http.iam.service.PermissionService;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IamPermissionService
implements PermissionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamPermissionService.class);
    private final IamPermissionApi iamPermissionApi;

    @Override
    public List<ActionPermissionInfoResDto> findPermissionByUserId(String appToken, String token, String userId, String sysId) {
        IamUserPermissionReqDto req = new IamUserPermissionReqDto();
        req.setUserId(userId);
        req.setSysId(sysId);
        ResultDto<List<IamUserPermissionDto>> resp = this.iamPermissionApi.fetchUserPermission(appToken, token, req);
        if (!resp.isSuccess() || resp.getData() == null) {
            log.error("\u67e5\u8be2\u7528\u6237\u6743\u9650\u5931\u8d25!resp:{}", resp);
            throw new BusinessException("\u67e5\u8be2\u7528\u6237\u6743\u9650\u5931\u8d25\uff01");
        }
        return CollUtil.map((Iterable)resp.getData(), this::toDto, (boolean)true);
    }

    public ActionPermissionInfoResDto toDto(IamUserPermissionDto dto) {
        if (dto == null) {
            return null;
        }
        ActionPermissionInfoResDto target = new ActionPermissionInfoResDto();
        target.setModuleId(dto.getModuleId());
        target.setEffect(dto.getEffect());
        return target;
    }

    @Generated
    public IamPermissionService(IamPermissionApi iamPermissionApi) {
        this.iamPermissionApi = iamPermissionApi;
    }
}

