/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.http.iam.service.impl;

import cn.hutool.cache.Cache;
import cn.hutool.cache.impl.LRUCache;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.func.Func0;
import cn.hutool.core.stream.CollectorUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.http.iam.IamProp;
import com.digiwin.athena.http.iam.api.IamTenantApi;
import com.digiwin.athena.http.iam.dto.IamLoginInfo;
import com.digiwin.athena.http.iam.dto.IamTenantBasicInfo;
import com.digiwin.athena.http.iam.dto.IamTenantReqDto;
import com.digiwin.athena.http.iam.dto.ResultDto;
import com.digiwin.athena.http.iam.dto.TenantInfoDto;
import com.digiwin.athena.http.iam.service.TenantInfoService;
import com.digiwin.athena.http.iam.service.TokenService;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IamTenantInfoFacadeService
implements TenantInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamTenantInfoFacadeService.class);
    private static Cache<String, TenantInfoDto> tenantInfoCache = new LRUCache(100, Duration.ofDays(1L).toMillis());
    private final IamProp prop;
    private final IamTenantApi iamTenantApi;
    private final TokenService tokenService;

    public static void setTenantInfoCache(Cache<String, TenantInfoDto> tenantInfoCache) {
        IamTenantInfoFacadeService.tenantInfoCache = tenantInfoCache;
    }

    @Override
    public TenantInfoDto getTenantInfoWithCache(String tenantId) {
        return (TenantInfoDto)tenantInfoCache.get((Object)tenantId, false, (Func0 & Serializable)() -> this.getTenantInfoDto(tenantId));
    }

    @Override
    public TenantInfoDto getTenantInfoDto(String tenantId) {
        if (StrUtil.isBlank((CharSequence)tenantId)) {
            return null;
        }
        return this.getTenantInfoDto(Collections.singleton(tenantId)).get(tenantId);
    }

    @Override
    public Map<String, TenantInfoDto> getTenantInfoWithCache(Collection<String> tenantIdColl) {
        if (CollUtil.isEmpty(tenantIdColl)) {
            return Collections.emptyMap();
        }
        return tenantIdColl.stream().map(this::getTenantInfoDto).filter(Objects::nonNull).collect(Collectors.toMap(TenantInfoDto::getTenantId, v -> v));
    }

    @Override
    public Map<String, TenantInfoDto> getTenantInfoDto(Collection<String> tenantIdColl) {
        if (CollUtil.isEmpty(tenantIdColl)) {
            return Collections.emptyMap();
        }
        try {
            IamLoginInfo integrationToken = this.tokenService.getIntegrationTokenWithCache((String)CollUtil.getFirst(tenantIdColl));
            if (integrationToken == null) {
                throw new BusinessException("\u83b7\u53d6\u96c6\u6210Token\u5f02\u5e38\uff01");
            }
            return this.fetchTenantInfoFromApi(this.prop.getAppToken(), integrationToken.getToken(), CollUtil.newHashSet(tenantIdColl));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u5931\u8d25: tenantIdColl={}, msg={}", new Object[]{tenantIdColl, e.getMessage(), e});
            return Collections.emptyMap();
        }
    }

    protected Map<String, TenantInfoDto> fetchTenantInfoFromApi(String appToken, String token, Set<String> tenantId) {
        if (CollUtil.isEmpty(tenantId)) {
            return Collections.emptyMap();
        }
        ResultDto<List<IamTenantBasicInfo>> resp = this.iamTenantApi.fetchTenantBasicInfoList(appToken, token, IamTenantReqDto.of(tenantId));
        if (!resp.isSuccess() || CollUtil.isEmpty((Collection)resp.getData())) {
            log.error("\u67e5\u8be2iam\u79df\u6237\u4fe1\u606f\u5931\u8d25\uff01resp:{}", resp);
            return Collections.emptyMap();
        }
        return (Map)resp.getData().stream().map(TenantInfoDto::from).collect(CollectorUtil.toMap(TenantInfoDto::getTenantId, v -> v, (v1, v2) -> v1));
    }

    @Generated
    public IamTenantInfoFacadeService(IamProp prop, IamTenantApi iamTenantApi, TokenService tokenService) {
        this.prop = prop;
        this.iamTenantApi = iamTenantApi;
        this.tokenService = tokenService;
    }
}

