package com.digiwin.athena.http.iam.service.impl;

import cn.hutool.cache.Cache;
import cn.hutool.cache.impl.LRUCache;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.http.iam.IamProp;
import com.digiwin.athena.http.iam.api.IamTokenApi;
import com.digiwin.athena.http.iam.dto.IamLoginInfo;
import com.digiwin.athena.http.iam.dto.IamLoginReqDto;
import com.digiwin.athena.http.iam.service.TokenService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.time.Duration;

@Slf4j
@Service
@RequiredArgsConstructor
public class IamTokenFacadeService implements TokenService {
    private static Cache<String, IamLoginInfo> tokenCache
            = new LRUCache<>(100, Duration.ofHours(1).toMillis());

    private final IamProp iamProp;
    private final IamTokenApi tokenApi;

    public static void setTokenCache(Cache<String, IamLoginInfo> tokenCache) {
        IamTokenFacadeService.tokenCache = tokenCache;
    }

    @Override
    public IamLoginInfo getIntegrationTokenWithCache(String tenantId) {
        return tokenCache.get(tenantId, false, () -> getIntegrationToken(tenantId));
    }

    @Override
    public IamLoginInfo getIntegrationToken(String tenantId) {
        IamLoginReqDto request = new IamLoginReqDto();

        request.setTenantId(tenantId);
        request.setUserId(iamProp.getIntegrationAcct());
        request.setPasswordHash(iamProp.getIntegrationPwdHashed());

        IamLoginInfo resp = tokenApi.login(iamProp.getAppToken(), request);
        if (resp == null || StrUtil.isBlank(resp.getToken())) {
            log.error("获取集成token异常！resp:{}", resp);
            // TODO pzz Optimize 抛出RpcException，包装http status、body
            throw new BusinessException("获取集成token异常！");
        }

        return resp;
    }
}
