package com.digiwin.athena.http.cac.service.impl;

import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.http.cac.api.CacAuthorizationApi;
import com.digiwin.athena.http.cac.service.AppAuthService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

@Slf4j
@RequiredArgsConstructor
@Service
public class CacAppAuthServiceImpl implements AppAuthService {
    private final CacAuthorizationApi cacAuthorizationApi;

    public Set<String> findAuthAppCodes(String appToken, String token, String tenantId, String iamUserId) {
        try {
            return cacAuthorizationApi.fetchEnabledAppCodes(appToken, token, tenantId, iamUserId);
        } catch (Exception e) {
            log.error("查询用户授权应用异常：tenantId:{},iamUserId：{}，msg:{}", tenantId, iamUserId, e.getMessage());
            throw new BusinessException("查询用户授权应用异常!msg:" + e.getMessage());
        }
    }
}