package com.digiwin.athena.http.distribution;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
public class RegisterFxJobReqDto {
    private String aah001;
    private String aah001_n1;
    private String aah001_n1_o;
    private String aah002;
    private String aah003;
    private String aah004;
    private String aah005;
    private String aah006;
    private String aah007;
    private String aah009;
    private String aah010;
    private String aahcdate;
    private String aahcdept;
    private String aahcorg;
    private String aahcper;
    private String aahent;
    private String aahlock;
    private String aahmdate;
    private String aahmper;
    private String aahnote;
    private String aahstus;
    private String aahtype;
    private List<String> aaiList = new ArrayList<>();
    /**
     * 按钮名称多语言
     */
    private List<?> aajList = new ArrayList<>();
    /**
     * 作业区块/字段组件表
     */
    private List<?> adeList = new ArrayList<>();
    private List<String> aakList = new ArrayList<>();
    private List<String> aalList = new ArrayList<>();
    private List<String> aallList = new ArrayList<>();
    private List<String> aamList = new ArrayList<>();
    private List<String> acjList = new ArrayList<>();
    private String isUpdMenu;

    public static RegisterFxJobReqDto createFxJobMenuParam(String pageDesignCode, String name){
        RegisterFxJobReqDto registerFxJobReqDto = new RegisterFxJobReqDto();
        registerFxJobReqDto.setAah001(pageDesignCode);
        registerFxJobReqDto.setAah001_n1(name);
        registerFxJobReqDto.setAah002("L");
        registerFxJobReqDto.setAah003("S1");
        registerFxJobReqDto.setAah005("fx");
        registerFxJobReqDto.setAah006("S");
        registerFxJobReqDto.setAahlock("1");
        registerFxJobReqDto.setAahstus("T");
        registerFxJobReqDto.setAahtype("i");
        registerFxJobReqDto.setIsUpdMenu("0");

        return registerFxJobReqDto;
    }

    public static JSONObject buildAde(String componentCode, MultiLanguageDTO<?> nameMultiLang) {
        JSONObject field = new JSONObject();
        field.put("ade002", componentCode);

        if (nameMultiLang != null) {
            field.put("ade002_n1", nameMultiLang.getZh_CN());
            field.put("ade002_n2", nameMultiLang.getZh_TW());
            field.put("ade002_n3", nameMultiLang.getEn_US());
        }

        return field;
    }

    public static JSONObject buildAaj(String jobCode, String componentCode, MultiLanguageDTO<?> nameMultiLang) {
        JSONObject field = new JSONObject();

        field.put("aaj001", jobCode);
        field.put("aaj002", componentCode);
        if (nameMultiLang != null) {
            field.put("aaj002_n1", nameMultiLang.getZh_CN());
            field.put("aaj002_n2", nameMultiLang.getZh_TW());
            field.put("aaj002_n3", nameMultiLang.getEn_US());
        }

        return field;
    }
}
