package com.digiwin.athena.http.iam;

import com.digiwin.athena.http.iam.api.IamAppApi;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class IamConfig {

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix = "external.iam")
    public IamProp iamProp() {
        return new IamProp();
    }

    @Configuration
    @ConditionalOnClass(FeignClient.class)
    @EnableFeignClients(basePackageClasses = {IamAppApi.class})
    static class IamFeignConfig {

    }

}
