package com.digiwin.athena.http.iam.api;

import com.digiwin.athena.http.iam.IamConstant;
import com.digiwin.athena.http.iam.dto.IamTenantBasicInfo;
import com.digiwin.athena.http.iam.dto.IamTenantReqDto;
import com.digiwin.athena.http.iam.dto.ResultDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

import java.util.List;

/**
 * IAM租户Feign客户端
 */
@FeignClient(name = "iam-tenant-service",
        url = "${module.iam.domain:}", path = "/api/iam/v2/tenant", primary = false)
public interface IamTenantApi {

    @PostMapping("/getname/list/info")
    ResultDto<List<IamTenantBasicInfo>> fetchTenantBasicInfoList(
            @RequestHeader(IamConstant.HEADER_APP) String appToken,
            @RequestHeader(IamConstant.HEADER_USER) String userToken,
            @RequestBody IamTenantReqDto request
    );
}
