package com.digiwin.athena.http.iam.dto;

import lombok.Data;

@Data
public class TenantInfoDto {

    private String tenantId;
    private String tenantName;
    private String expiredDateTime;
    private String customerId;
    private Long tenantSid;


    /**
     * 转换IamTenantBasicInfo为TenantInfo
     */
    public static TenantInfoDto from(IamTenantBasicInfo source) {
        TenantInfoDto dto = new TenantInfoDto();

        dto.setTenantId(source.getId());
        dto.setTenantName(source.getName());
        dto.setCustomerId(source.getCustomerId());
        dto.setTenantSid(Long.parseLong(source.getSid()));

        return dto;
    }
}
