package com.digiwin.athena.http.iam.api;

import com.digiwin.athena.http.iam.IamConstant;
import com.digiwin.athena.http.iam.dto.IamAppInfo;
import com.digiwin.athena.http.iam.dto.IamAppTokenReqDto;
import com.digiwin.athena.http.iam.dto.ResultDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * IAM应用API（OpenFeign接口）
 */
@FeignClient(name = "iam-app-service",
        url = "${module.iam.domain:}", path = "/api/iam/v2/dev/app", primary = false)
public interface IamAppApi {

    /**
     * 检查IAM应用是否存在
     *
     * @param appToken  应用认证token
     * @param userToken 用户认证token
     * @param appCode   应用编码
     * @return IAM返回结果
     */
    @GetMapping("/id/{appCode}/prod/existed")
    ResultDto<Boolean> checkAppExist(
            @RequestHeader(IamConstant.HEADER_APP) String appToken,
            @RequestHeader(IamConstant.HEADER_USER) String userToken,
            @PathVariable("appCode") String appCode
    );

    /**
     * 获取IAM生成的应用的appToken
     *
     * @param appToken  应用认证token
     * @param userToken 用户认证token
     * @param request   请求参数
     * @return 应用信息
     */
    @PostMapping("/one")
    ResultDto<IamAppInfo> fetchAppInfo(
            @RequestHeader(IamConstant.HEADER_APP) String appToken,
            @RequestHeader(IamConstant.HEADER_USER) String userToken,
            @RequestBody IamAppTokenReqDto request
    );
}
