package com.digiwin.athena.http.iam.dto;

import lombok.Data;

import java.util.Collections;
import java.util.Set;

@Data
public class IamTenantReqDto {
    /**
     * 租户id列表
     */
    private Set<String> tenantIds;

    public static IamTenantReqDto of(String tenantId) {
        return of(Collections.singleton(tenantId));
    }

    public static IamTenantReqDto of(Set<String> tenantIds) {
        IamTenantReqDto dto = new IamTenantReqDto();

        dto.setTenantIds(tenantIds);

        return dto;
    }
}
