package com.digiwin.athena.http.iam.service.impl;

import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.http.iam.api.IamAppApi;
import com.digiwin.athena.http.iam.dto.IamAppInfo;
import com.digiwin.athena.http.iam.dto.IamAppTokenReqDto;
import com.digiwin.athena.http.iam.dto.ResultDto;
import com.digiwin.athena.http.iam.service.AppService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@RequiredArgsConstructor
@Service
public class IamAppFacadeService implements AppService {
    protected final IamAppApi iamAppApi;


    @Override
    public boolean checkAppExist(String appToken, String userToken, String appCode) {
        ResultDto<Boolean> result = iamAppApi.checkAppExist(appToken, userToken, appCode);
        // 处理返回结果
        if (result == null || !result.getSuccess() || result.getData() == null) {
            log.warn("IAM应用检查失败，appCode: {}, result: {}", appCode, result);
            throw new BusinessException("IAM应用存在检查失败！");
        }

        log.info("检查IAM应用是否存在，appCode: {},exist:{}", appCode, result.getData());
        return result.getData();
    }

    @Override
    public String findAppTokenByCode(String appToken, String token, String code) {
        ResultDto<IamAppInfo> appInfoResp = iamAppApi.fetchAppInfo(appToken, token, IamAppTokenReqDto.of(code));
        if (!appInfoResp.getSuccess() || appInfoResp.getData() == null) {
            log.error("获取应用token失败: {}", appInfoResp.getMessage());
            throw new BusinessException("获取应用token失败: " + appInfoResp.getMessage());
        }

        IamAppInfo data = appInfoResp.getData();
        return data.getAppToken();
    }

}
