package com.digiwin.athena.http.iam.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.http.iam.api.IamPermissionApi;
import com.digiwin.athena.http.iam.dto.ActionPermissionInfoResDto;
import com.digiwin.athena.http.iam.dto.IamUserPermissionDto;
import com.digiwin.athena.http.iam.dto.IamUserPermissionReqDto;
import com.digiwin.athena.http.iam.dto.ResultDto;
import com.digiwin.athena.http.iam.service.PermissionService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@RequiredArgsConstructor
@Service
public class IamPermissionFacadeService implements PermissionService {

    private final IamPermissionApi iamPermissionApi;

    @Override
    public List<ActionPermissionInfoResDto> findPermissionByUserId(String appToken, String token,
                                                                   String userId, String sysId) {
        IamUserPermissionReqDto req = new IamUserPermissionReqDto();
        req.setUserId(userId);
        req.setSysId(sysId);

        ResultDto<List<IamUserPermissionDto>> resp = iamPermissionApi.fetchUserPermission(appToken, token, req);
        if (!resp.isSuccess() || resp.getData() == null) {
            log.error("查询用户权限失败!resp:{}", resp);
            throw new BusinessException("查询用户权限失败！");
        }

        return CollUtil.map(resp.getData(), this::toDto, true);
    }

    public ActionPermissionInfoResDto toDto(IamUserPermissionDto dto) {
        if (dto == null) {
            return null;
        }

        ActionPermissionInfoResDto target = new ActionPermissionInfoResDto();

        target.setModuleId(dto.getModuleId());
        target.setEffect(dto.getEffect());

        return target;
    }


}
