/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.http.iam.service.impl;

import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.http.iam.api.IamAppApi;
import com.digiwin.athena.http.iam.dto.IamAppInfo;
import com.digiwin.athena.http.iam.dto.IamAppTokenReqDto;
import com.digiwin.athena.http.iam.dto.ResultDto;
import com.digiwin.athena.http.iam.service.AppService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IamAppFacadeService
implements AppService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamAppFacadeService.class);
    protected final IamAppApi iamAppApi;

    @Override
    public boolean checkAppExist(String appToken, String userToken, String appCode) {
        ResultDto<Boolean> result = this.iamAppApi.checkAppExist(appToken, userToken, appCode);
        if (result == null || !result.getSuccess() || result.getData() == null) {
            log.warn("IAM\u5e94\u7528\u68c0\u67e5\u5931\u8d25\uff0cappCode: {}, result: {}", (Object)appCode, result);
            throw new BusinessException("IAM\u5e94\u7528\u5b58\u5728\u68c0\u67e5\u5931\u8d25\uff01");
        }
        log.info("\u68c0\u67e5IAM\u5e94\u7528\u662f\u5426\u5b58\u5728\uff0cappCode: {},exist:{}", (Object)appCode, (Object)result.getData());
        return result.getData();
    }

    @Override
    public String findAppTokenByCode(String appToken, String token, String code) {
        ResultDto<IamAppInfo> appInfoResp = this.iamAppApi.fetchAppInfo(appToken, token, IamAppTokenReqDto.of(code));
        if (!appInfoResp.getSuccess() || appInfoResp.getData() == null) {
            log.error("\u83b7\u53d6\u5e94\u7528token\u5931\u8d25: {}", (Object)appInfoResp.getMessage());
            throw new BusinessException("\u83b7\u53d6\u5e94\u7528token\u5931\u8d25: " + appInfoResp.getMessage());
        }
        IamAppInfo data = appInfoResp.getData();
        return data.getAppToken();
    }

    @Generated
    public IamAppFacadeService(IamAppApi iamAppApi) {
        this.iamAppApi = iamAppApi;
    }
}

