/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.http.iam.service.impl;

import cn.hutool.cache.Cache;
import cn.hutool.cache.impl.LRUCache;
import cn.hutool.core.lang.func.Func0;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.http.iam.IamProp;
import com.digiwin.athena.http.iam.api.IamTokenApi;
import com.digiwin.athena.http.iam.dto.IamLoginInfo;
import com.digiwin.athena.http.iam.dto.IamLoginReqDto;
import com.digiwin.athena.http.iam.service.TokenService;
import java.io.Serializable;
import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IamTokenFacadeService
implements TokenService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamTokenFacadeService.class);
    private static Cache<String, IamLoginInfo> tokenCache = new LRUCache(100, Duration.ofHours(1L).toMillis());
    private final IamProp iamProp;
    private final IamTokenApi tokenApi;

    public static void setTokenCache(Cache<String, IamLoginInfo> tokenCache) {
        IamTokenFacadeService.tokenCache = tokenCache;
    }

    @Override
    public IamLoginInfo getIntegrationTokenWithCache(String tenantId) {
        return (IamLoginInfo)tokenCache.get((Object)tenantId, false, (Func0 & Serializable)() -> this.getIntegrationToken(tenantId));
    }

    @Override
    public IamLoginInfo getIntegrationToken(String tenantId) {
        IamLoginReqDto request = new IamLoginReqDto();
        request.setTenantId(tenantId);
        request.setUserId(this.iamProp.getIntegrationAcct());
        request.setPasswordHash(this.iamProp.getIntegrationPwdHashed());
        IamLoginInfo resp = this.tokenApi.login(this.iamProp.getAppToken(), request);
        if (resp == null || StrUtil.isBlank((CharSequence)resp.getToken())) {
            log.error("\u83b7\u53d6\u96c6\u6210token\u5f02\u5e38\uff01resp:{}", (Object)resp);
            throw new BusinessException("\u83b7\u53d6\u96c6\u6210token\u5f02\u5e38\uff01");
        }
        return resp;
    }

    @Generated
    public IamTokenFacadeService(IamProp iamProp, IamTokenApi tokenApi) {
        this.iamProp = iamProp;
        this.tokenApi = tokenApi;
    }
}

