package com.digiwin.athena.domain.user;

import com.digiwin.athena.base.BusinessException;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @ClassName UserDO
 * @Description TODO
 * @Author zhuangli
 * @Date 2021/9/1 9:47
 * @Version 1.0
 **/
@Data
public class UserDO {

    private Long id;
    private Long gitId;
    /**
     * 同iam的sid
     */
    private Long iamId;
    /**
     * 同iam的userId
     */
    private String name;
    /**
     * 同iam的userId
     */
    private String userId;
    /**
     * 同iam的password
     */
    private String password;
    private String passwordHash;
    private String clientEncryptPublicKey;
    /**
     * 同iam的userName
     */
    private String nickName;
    private String accessToken;
    private String refreshToken;
    private Integer state;
    private LocalDateTime createTime;
    private LocalDateTime modifyTime;
    private String token;
    private String iamToken;
    private String tenantId;
    private String tenantName;
    private String code;
    private String currentBranch;
    /**
     * 同iam的agreeAgreement
     */
    private boolean agreeAgreement;

    // 终端唯一标识
    private String deviceId;

    // 登录类型   verificationCode 验证码登录
    private String identityType;

    // 登录类型 =  verificationCode 验证码登录
    private String verificationCode;

    public void init() {
        state = 0;
    }

    public void sign() {
        switch (state) {
            case 0:
                state = 1;
                break;
            default:
                throw new BusinessException("The current user status cannot be registered");
        }
    }

    public void bind() {
        switch (state) {
            case 1:
                state = 2;
                break;
            default:
                throw new BusinessException("The current user status cannot be registered");
        }
    }
}
