package com.digiwin.athena.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dto.SystemParam;
import com.digiwin.athena.http.distribution.ProgramAuthResDto;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * 多平台差异接口
 */
public interface MultiPlatformDiffInterface {
    /**
     * 获取系统变量
     * @return
     */
    @Deprecated
    JSONObject getSysEnum();
    List<SystemParam> getSysEnumV2();

    ProgramAuthResDto getProgramAuth(String code);


    <T> T uploadFile(MultipartFile file, String programCode) throws IOException;

    default <T> T uploadFileV3(MultipartFile file, String componentId, String programId) throws IOException { return null;}

    default <T> T  queryUploadedFileInfo(List<String> fileIds){return null;}

    default <T> Collection<T> getAuthPageDesign(Collection<String> allCodes, String application){
        return (Collection<T>) allCodes;
    }

    default Collection<String> getAuthPageDesign(Collection<String> codesSet, Collection<String> appCodes){
        return codesSet;
    };

    default void deleteAllRegisterInfo(Set<String> pageCodes){};
}
