/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.validate;

import com.digiwin.athena.dto.action.MultiLanguageDTO;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;

@Documented
@Constraint(validatedBy={LangLenValidator.class, MapLangLenValidator.class})
@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@Repeatable(value=List.class)
public @interface ValidLangLen {
    public int min() default 0;

    public int max() default 0x7FFFFFFF;

    public String message() default "{org.hibernate.validator.constraints.Length.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class MapLangLenValidator
    implements ConstraintValidator<ValidLangLen, Map<String, MultiLanguageDTO<?>>> {
        private int min;
        private int max;

        public void initialize(ValidLangLen constraintAnnotation) {
            this.max = constraintAnnotation.max();
            this.min = constraintAnnotation.min();
        }

        public boolean isValid(Map<String, MultiLanguageDTO<?>> map, ConstraintValidatorContext context) {
            if (map == null || map.isEmpty()) {
                return true;
            }
            MultiLanguageDTO<?> address = map.get("name");
            return LangLenValidator.judgeLen(address, this.max);
        }
    }

    public static class LangLenValidator
    implements ConstraintValidator<ValidLangLen, MultiLanguageDTO<?>> {
        private int min;
        private int max;

        private static boolean judgeLen(MultiLanguageDTO<?> address, int max) {
            return address != null && address.getZh_CN() != null && String.valueOf(address.getZh_CN()).length() <= max && address.getEn_US() != null && String.valueOf(address.getEn_US()).length() <= max && address.getZh_TW() != null && String.valueOf(address.getZh_TW()).length() <= max;
        }

        public void initialize(ValidLangLen constraintAnnotation) {
            this.min = constraintAnnotation.min();
            this.max = constraintAnnotation.max();
        }

        public boolean isValid(MultiLanguageDTO address, ConstraintValidatorContext context) {
            return LangLenValidator.judgeLen(address, this.max);
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public ValidLangLen[] value();
    }
}

