package com.digiwin.athena.dto;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.domain.UserDefinedCenter;
import com.digiwin.athena.mongodb.domain.appCustomConfig.ApplicationCustomConfig;
import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.domain.PageDsl;
import com.digiwin.athena.http.distribution.ProgramAuthResDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.ArrayList;
import java.util.List;

@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
public class PageDesignDto extends PageDesign {

    /**
     * 主页面dsl
     */
    private PageDsl pageDsl;

    private List<PageDsl> pageDslList;

    /**
     * 权限信息
     */
    private List<ProgramAuthResDto.AuthInfo> authInfo;

    private List<ApplicationCustomConfig> applicationCustomConfigs = new ArrayList<>();

    private List<UserDefinedCenter> userDefinedCenters;
}