/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao;

import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.mongodb.repository.MongoMultiRepositoryDecorator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;

@Repository
public class DPageDesignDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DPageDesignDao.class);
    @Autowired
    private MongoMultiRepositoryDecorator mongoMultiRepositoryDecorator;

    public void insert(PageDesign pageDesign) {
        this.mongoMultiRepositoryDecorator.insert((Object)pageDesign);
    }

    public PageDesign selectByCodeAndApplication(String code, String application) {
        Criteria criteria = Criteria.where((String)"code").is((Object)code).and("adpApplication").is((Object)application);
        return (PageDesign)this.mongoMultiRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), PageDesign.class);
    }

    public void save(PageDesign pageDesign) {
        this.mongoMultiRepositoryDecorator.save((Object)pageDesign);
    }

    public void deleteByCodeAndApplication(String code, String application) {
        Criteria criteria = Criteria.where((String)"code").is((Object)code).and("adpApplication").is((Object)application);
        this.mongoMultiRepositoryDecorator.remove(new Query((CriteriaDefinition)criteria), PageDesign.class);
    }

    public List<PageDesign> selectByApplication(String application) {
        Criteria criteria = Criteria.where((String)"adpApplication").is((Object)application);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        return this.mongoMultiRepositoryDecorator.find(query, PageDesign.class);
    }

    public void updatePublishedTime(String code, String adpApplication, Date publishedTime) {
        Criteria criteria = Criteria.where((String)"code").is((Object)code).and("adpApplication").is((Object)adpApplication);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update().set("publishedTime", (Object)publishedTime);
        this.mongoMultiRepositoryDecorator.updateFirst(query, update, PageDesign.class);
    }

    public Collection<? extends String> selectCodeByApplication(String appCode) {
        Criteria criteria = Criteria.where((String)"adpApplication").is((Object)appCode);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("code");
        return this.mongoMultiRepositoryDecorator.find(query, PageDesign.class).stream().map(PageDesign::getCode).collect(Collectors.toList());
    }
}

