/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao;

import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.mongodb.repository.MongoRuntimeRepositoryDecorator;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class RPageDesignDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RPageDesignDao.class);
    @Autowired
    private MongoRuntimeRepositoryDecorator mongoRuntimeRepositoryDecorator;

    public void insert(PageDesign pageDesign) {
        this.mongoRuntimeRepositoryDecorator.insert((Object)pageDesign);
    }

    public long deleteByCode(String code) {
        Criteria criteria = Criteria.where((String)"code").is((Object)code);
        return this.mongoRuntimeRepositoryDecorator.remove(new Query((CriteriaDefinition)criteria), PageDesign.class);
    }

    public void update(PageDesign pageDesign) {
        this.mongoRuntimeRepositoryDecorator.save((Object)pageDesign);
    }

    public PageDesign findByCode(String code) {
        Criteria criteria = Criteria.where((String)"code").is((Object)code);
        return (PageDesign)this.mongoRuntimeRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), PageDesign.class);
    }

    public List<PageDesign> find(Query query) {
        return this.mongoRuntimeRepositoryDecorator.find(query, PageDesign.class);
    }

    public PageDesign findOne(Query query) {
        return (PageDesign)this.mongoRuntimeRepositoryDecorator.findOne(query, PageDesign.class);
    }

    public void delete(PageDesign pageDesign) {
        this.mongoRuntimeRepositoryDecorator.delete((Object)pageDesign);
    }

    public void deleteByCodeAndApplication(String code, String application) {
        Criteria criteria = Criteria.where((String)"code").is((Object)code).and("adpApplication").is((Object)application);
        this.mongoRuntimeRepositoryDecorator.delete(new Query((CriteriaDefinition)criteria), PageDesign.class);
    }

    public List<PageDesign> selectByApplication(String application) {
        Criteria criteria = Criteria.where((String)"adpApplication").is((Object)application);
        return this.mongoRuntimeRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), PageDesign.class);
    }

    public Set<String> selectCodeByAdpApplication(String adpApplication) {
        Criteria criteria = Criteria.where((String)"adpApplication").is((Object)adpApplication);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("code");
        return this.mongoRuntimeRepositoryDecorator.find(query, PageDesign.class).stream().map(PageDesign::getCode).collect(Collectors.toSet());
    }

    public void deleteByCodes(Collection<String> rCodes, String adpApplication) {
        Criteria criteria = Criteria.where((String)"code").in(rCodes).and("adpApplication").is((Object)adpApplication);
        this.mongoRuntimeRepositoryDecorator.delete(new Query((CriteriaDefinition)criteria), PageDesign.class);
    }

    public void deleteByApplication(String appCode) {
        Criteria criteria = Criteria.where((String)"adpApplication").is((Object)appCode);
        this.mongoRuntimeRepositoryDecorator.delete(new Query((CriteriaDefinition)criteria), PageDesign.class);
    }

    public List<PageDesign> queryMobileByAppCodes(Collection appCodes) {
        Criteria criteria = Criteria.where((String)"adpApplication").in(appCodes).and("isMobile").is((Object)true);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoRuntimeRepositoryDecorator.find(query, PageDesign.class);
    }
}

