/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.service.MultiPlatformDiffInterface;
import com.digiwin.athena.service.RPageDesignService;
import com.digiwin.athena.service.RuntimeDataQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="appMobilePageDesignRuntime")
public class AppMobilePageDesignRuntimeDataQuery
implements RuntimeDataQuery {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppMobilePageDesignRuntimeDataQuery.class);
    @Autowired
    private RPageDesignService rPageDesignService;
    @Autowired
    private MultiPlatformDiffInterface multiPlatformDiffInterface;

    public Object queryRuntimeData(JSONObject param) {
        JSONArray appCodes = param.getJSONArray("appCodes");
        if (!CollectionUtils.isEmpty((Collection)appCodes)) {
            List appCodesList = appCodes.stream().map(c -> String.valueOf(c)).collect(Collectors.toList());
            List<PageDesign> pageDesignList = this.rPageDesignService.queryMobileByAppCodes(appCodesList);
            Set codesSet = pageDesignList.stream().map(PageDesign::getCode).collect(Collectors.toSet());
            if (codesSet.isEmpty()) {
                return Collections.emptyList();
            }
            Collection authCodes = this.multiPlatformDiffInterface.getAuthPageDesign(codesSet, appCodesList);
            return pageDesignList.stream().filter(p -> authCodes.contains(p.getCode())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

