package com.digiwin.athena.dto;

import com.digiwin.athena.domain.Dsl;
import com.digiwin.athena.domain.PageDesignTime;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import lombok.Data;

@Data
public class SavePageDesignReqDto {

    @Schema(description = "页面code")
    @NotEmpty(message = "页面code不能为空")
    private String code;
    @Schema(description = "作业code")
    @NotEmpty(message = "作业code不能为空")
    private String pageDesignCode;
    @Schema(description = "应用code")
    @NotEmpty(message = "应用code不能为空")
    private String adpApplication;
    @Schema(description = "页面设计")
    private Dsl dsl;

    @Schema(description = "页面设计时数据")
    @Valid
    private PageDesignTime designTime;
}
