package com.digiwin.athena.dao;

import com.digiwin.athena.domain.DeployDetail;
import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.mongodb.repository.MongoMultiRepositoryDecorator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Repository
public class DPageDesignDao {

    @Autowired
    private MongoMultiRepositoryDecorator mongoMultiRepositoryDecorator;

    public void insert(PageDesign pageDesign) {
        mongoMultiRepositoryDecorator.insert(pageDesign);
    }

    public PageDesign selectByCodeAndApplication(String code, String application) {
        Criteria criteria = Criteria.where("code").is(code).and("adpApplication").is(application);
        return mongoMultiRepositoryDecorator.findOne(new Query(criteria),PageDesign.class);
    }

    public void save(PageDesign pageDesign) {
        mongoMultiRepositoryDecorator.save(pageDesign);
    }

    public void deleteByCodeAndApplication(String code, String application) {
        Criteria criteria = Criteria.where("code").is(code).and("adpApplication").is(application);
        mongoMultiRepositoryDecorator.remove(new Query(criteria),PageDesign.class);
    }

    public List<PageDesign> selectByApplication(String application) {
        Criteria criteria = Criteria.where("adpApplication").is(application);
        Query query = new Query(criteria);
        query.with(Sort.by(Sort.Direction.ASC,"_id"));
        return mongoMultiRepositoryDecorator.find(query,PageDesign.class);
    }

    public void updatePublishedTime(String code, String adpApplication, Date publishedTime) {
        Criteria criteria = Criteria.where("code").is(code).and("adpApplication").is(adpApplication);
        Query query = new Query(criteria);

        Update update = new Update().set("publishedTime", publishedTime);

        mongoMultiRepositoryDecorator.updateFirst(query, update, PageDesign.class);

    }

    public Collection<? extends String> selectCodeByApplication(String appCode) {
        Criteria criteria = Criteria.where("adpApplication").is(appCode);
        Query query = new Query(criteria);
        query.fields().include("code");
        return mongoMultiRepositoryDecorator.find(query, PageDesign.class).stream().map(PageDesign::getCode).collect(Collectors.toList());
    }
}
