/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.dao.DPageDesignDao;
import com.digiwin.athena.dao.DPageDslDao;
import com.digiwin.athena.domain.Dsl;
import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.domain.PageDesignTime;
import com.digiwin.athena.domain.PageDsl;
import com.digiwin.athena.dto.CreatePageDesignDto;
import com.digiwin.athena.dto.PageDslDto;
import com.digiwin.athena.dto.QueryPageDesignResDto;
import com.digiwin.athena.dto.SavePageDesignBasicInfoReqDto;
import com.digiwin.athena.dto.SavePageDesignReqDto;
import com.digiwin.athena.dto.SystemParam;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.service.ActionMetaDataService;
import com.digiwin.athena.service.DPageDesignService;
import com.digiwin.athena.service.MultiPlatformDiffInterface;
import com.digiwin.athena.service.appCustomConfig.event.CustomControlEventManager;
import com.digiwin.athena.service.codeStandard.BuildGeneratorCodeUtil;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.operation.OperationRecordWrapper;
import com.digiwin.athena.utils.operation.aspect.RecordCommitLocal;
import com.digiwin.athena.utils.user.UserHelper;
import com.digiwin.athena.vo.action.ActionInfoResp;
import com.digiwin.athena.vo.action.ActionVersionReq;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DPageDesignServiceImpl
implements DPageDesignService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DPageDesignServiceImpl.class);
    @Autowired
    private DPageDslDao dPageDslDao;
    @Autowired
    private DPageDesignDao dPageDesignDao;
    @Autowired
    private BuildGeneratorCodeUtil buildGeneratorCodeUtil;
    @Autowired
    private MultiPlatformDiffInterface multiPlatformDiffInterface;
    @Autowired
    private CustomControlEventManager customControlEventManager;
    @Autowired
    private ActionMetaDataService actionMetaDataService;

    @Override
    public String createPageDesign(CreatePageDesignDto createPageDesignDto) {
        String deCode = this.buildGeneratorCodeUtil.createStandardCode(createPageDesignDto.getApplication(), Boolean.TRUE.equals(createPageDesignDto.getIsMobile()) ? "H5" : "DE");
        String browseDslCode = this.buildGeneratorCodeUtil.createStandardCode(createPageDesignDto.getApplication(), "DSL");
        String editDslCode = this.buildGeneratorCodeUtil.createStandardCode(createPageDesignDto.getApplication(), "DSL");
        PageDesign pageDesign = createPageDesignDto.createPageDesign();
        pageDesign.setCode(deCode);
        List<Object> pageDslList = new ArrayList();
        if (CollectionUtils.isEmpty(createPageDesignDto.getPageDslList())) {
            pageDesign.setDslCode(browseDslCode);
            PageDsl browsePageDsl = createPageDesignDto.createPageDsl();
            browsePageDsl.setCode(browseDslCode);
            browsePageDsl.setPageDesignCode(deCode);
            browsePageDsl.setType("basic_table".equals(createPageDesignDto.getTemplateType()) ? "browse" : "design");
            browsePageDsl.setName("basic_table".equals(createPageDesignDto.getTemplateType()) ? "\u6d4f\u89c8\u754c\u9762" : "\u754c\u9762\u8bbe\u8ba1");
            if ("basic_table".equals(createPageDesignDto.getTemplateType())) {
                browsePageDsl.setLang((Map)JSONObject.parseObject((String)"{\"name\": {\"zh_CN\": \"\u6d4f\u89c8\u754c\u9762\",\"zh_TW\": \"\u700f\u89bd\u4ecb\u9762\",\"en_US\": \"Browse Page\"}}", (TypeReference)new TypeReference<Map<String, MultiLanguageDTO>>(){}, (Feature[])new Feature[0]));
            } else {
                browsePageDsl.setLang((Map)JSONObject.parseObject((String)"{\"name\": {\"zh_CN\": \"\u754c\u9762\u8bbe\u8ba1\",\"zh_TW\": \"\u4ecb\u9762\u8a2d\u8a08\",\"en_US\": \"Interface Design\"}}", (TypeReference)new TypeReference<Map<String, MultiLanguageDTO>>(){}, (Feature[])new Feature[0]));
            }
            pageDslList.add((Object)browsePageDsl);
            if ("basic_table".equals(createPageDesignDto.getTemplateType())) {
                PageDsl editPageDsl = createPageDesignDto.createPageDsl();
                editPageDsl.setCode(editDslCode);
                editPageDsl.setPageDesignCode(deCode);
                editPageDsl.setType("edit");
                editPageDsl.setName("\u7f16\u8f91\u754c\u9762");
                editPageDsl.setLang((Map)JSONObject.parseObject((String)"{ \"name\": {  \"zh_CN\": \"\u7f16\u8f91\u754c\u9762\",  \"zh_TW\": \"\u7f16\u8f91\u754c\u9762\",  \"en_US\": \"Edit Page\" }}", (TypeReference)new TypeReference<Map<String, MultiLanguageDTO>>(){}, (Feature[])new Feature[0]));
                this.dPageDslDao.insert(editPageDsl);
                pageDslList.add((Object)editPageDsl);
            }
            this.dPageDslDao.insert(browsePageDsl);
        } else {
            List<PageDslDto> pageDslDtoList = createPageDesignDto.getPageDslList();
            pageDslList = pageDslDtoList.stream().map(pageDslDto -> {
                PageDsl pageDsl = new PageDsl();
                pageDsl.setAdpApplication(createPageDesignDto.getApplication());
                pageDsl.setAdpTenantId(CurThreadInfoUtils.getCurTokenTenant().getTenantId());
                pageDsl.setVersion(createPageDesignDto.getVersion());
                pageDsl.setPageDesignCode(pageDesign.getCode());
                pageDsl.setCode(pageDslDto.getCode());
                pageDsl.setType(pageDslDto.getType());
                pageDsl.setDsl(pageDslDto.getDsl());
                pageDsl.setDesignTime(pageDslDto.getDesignTime());
                pageDsl.setName(pageDslDto.getName());
                pageDsl.setLang(pageDslDto.getLang());
                UserHelper.fillCreateInfo((Object)((Object)pageDsl));
                UserHelper.fillEditInfo((Object)((Object)pageDsl));
                this.dPageDslDao.insert(pageDsl);
                return pageDsl;
            }).collect(Collectors.toList());
        }
        this.dPageDesignDao.insert(pageDesign);
        JSONObject pageDesignJo = JSON.parseObject((String)JSON.toJSONString((Object)pageDesign));
        pageDesignJo.put("pageDslList", pageDslList);
        RecordCommitLocal.add((OperationRecordWrapper)new OperationRecordWrapper(pageDesign.getAdpApplication(), "lcdp_pageDesign", (Object)pageDesignJo, "create"));
        return deCode;
    }

    @Override
    public QueryPageDesignResDto queryPageDesign(String code, String application) {
        List sysEnumList = this.multiPlatformDiffInterface.getSysEnumV2();
        ArrayList<JSONObject> variables = new ArrayList<JSONObject>();
        for (SystemParam systemParam : sysEnumList) {
            JSONObject variable = new JSONObject();
            variable.put("name", (Object)systemParam.getKey());
            variable.put("defaultValue", (Object)systemParam.getValue());
            variable.put("scope", (Object)"system");
            variable.put("description", (Object)systemParam.getDesc());
            variables.add(variable);
        }
        PageDesign pageDesign = this.dPageDesignDao.selectByCodeAndApplication(code, application);
        Assert.notNull((Object)pageDesign, (String)(code + "\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u8bb0\u5f55"));
        List<PageDsl> pageDslList = this.dPageDslDao.selectByPageDesignCode(code, application);
        for (PageDsl pageDsl : pageDslList) {
            if (pageDsl.getDsl() == null) continue;
            if (CollectionUtils.isEmpty(pageDsl.getDsl().getVariables())) {
                pageDsl.getDsl().setVariables(variables);
                continue;
            }
            Iterator<JSONObject> iterator = pageDsl.getDsl().getVariables().iterator();
            while (iterator.hasNext()) {
                JSONObject next = iterator.next();
                if (!"system".equals(next.getString("scope"))) continue;
                iterator.remove();
            }
            pageDsl.getDsl().getVariables().addAll(variables);
        }
        QueryPageDesignResDto res = QueryPageDesignResDto.create(pageDesign);
        res.setPageDslList(pageDslList);
        res.setPublishedTime(pageDesign.getPublishedTime());
        return res;
    }

    @Override
    public void savePageDesign(List<SavePageDesignReqDto> savePageDesignReqDtoList) {
        Assert.isTrue((!CollectionUtils.isEmpty(savePageDesignReqDtoList) ? 1 : 0) != 0, (String)"dsl\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        SavePageDesignReqDto pd = savePageDesignReqDtoList.get(0);
        PageDesign pageDesign = this.dPageDesignDao.selectByCodeAndApplication(pd.getPageDesignCode(), pd.getAdpApplication());
        Assert.notNull((Object)pageDesign, (String)(pd.getPageDesignCode() + "\u4e0d\u5b58\u5728"));
        JSONObject pageDesignJo = JSON.parseObject((String)JSON.toJSONString((Object)pageDesign));
        ArrayList<PageDsl> pageDslList = new ArrayList<PageDsl>();
        pageDesignJo.put("pageDslList", pageDslList);
        for (SavePageDesignReqDto savePageDesignReqDto : savePageDesignReqDtoList) {
            PageDesignTime designTime = savePageDesignReqDto.getDesignTime();
            PageDsl pageDsl = this.dPageDslDao.selectByCodeAndApplication(savePageDesignReqDto.getCode(), savePageDesignReqDto.getPageDesignCode(), savePageDesignReqDto.getAdpApplication());
            pageDsl.setDsl(savePageDesignReqDto.getDsl());
            pageDsl.setDesignTime(designTime);
            pageDslList.add(pageDsl);
            UserHelper.fillEditInfo((Object)((Object)pageDsl));
            this.dPageDslDao.save(pageDsl);
        }
        this.customControlEventManager.notify(CustomControlEventManager.EvenType.NEW_PAGE_DESIGN, (Object)pageDesignJo);
        RecordCommitLocal.add((OperationRecordWrapper)new OperationRecordWrapper(pageDesign.getAdpApplication(), "lcdp_pageDesign", (Object)pageDesignJo, "update"));
    }

    @Override
    public void savePageDesignBasicInfo(SavePageDesignBasicInfoReqDto savePageDesignBasicInfoReqDto) {
        PageDesign pageDesign = this.dPageDesignDao.selectByCodeAndApplication(savePageDesignBasicInfoReqDto.getCode(), savePageDesignBasicInfoReqDto.getApplication());
        Assert.notNull((Object)pageDesign, (String)(savePageDesignBasicInfoReqDto.getCode() + "\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8bb0\u5f55"));
        pageDesign.setName(savePageDesignBasicInfoReqDto.getName());
        pageDesign.setLang(savePageDesignBasicInfoReqDto.getLang());
        UserHelper.fillEditInfo((Object)pageDesign);
        this.dPageDesignDao.save(pageDesign);
        RecordCommitLocal.add((OperationRecordWrapper)new OperationRecordWrapper(pageDesign.getAdpApplication(), "lcdp_pageDesign", (Object)JSON.parseObject((String)JSON.toJSONString((Object)pageDesign)), "update"));
    }

    @Override
    public void deletePageDesign(String code, String application) {
        PageDesign pageDesign = this.dPageDesignDao.selectByCodeAndApplication(code, application);
        Assert.notNull((Object)pageDesign, (String)(code + "\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u8bb0\u5f55"));
        this.dPageDslDao.deleteByPageDesignCodeAndApplication(code, application);
        this.dPageDesignDao.deleteByCodeAndApplication(code, application);
        RecordCommitLocal.add((OperationRecordWrapper)new OperationRecordWrapper(pageDesign.getAdpApplication(), "lcdp_pageDesign", (Object)JSON.parseObject((String)JSON.toJSONString((Object)pageDesign)), "delete"));
    }

    @Override
    public List<PageDesign> queryPageDesign(String application) {
        return this.dPageDesignDao.selectByApplication(application);
    }

    @Override
    public List<PageDsl> queryPageDslBasic(String application) {
        return this.dPageDslDao.selectBasicByApplication(application);
    }

    @Override
    public List<PageDsl> getPagesBasicInfo(String code, String application) {
        List<PageDsl> res = this.dPageDslDao.selectBasicByPageDesignCodeAndApplication(code, application);
        return res;
    }

    @Override
    public QueryPageDesignResDto queryBasicPageDesign(String code, String application) {
        PageDesign pageDesign = this.dPageDesignDao.selectByCodeAndApplication(code, application);
        Assert.notNull((Object)pageDesign, (String)(code + "\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u8bb0\u5f55"));
        QueryPageDesignResDto res = QueryPageDesignResDto.create(pageDesign);
        return res;
    }

    @Override
    public List<QueryPageDesignResDto> getAppPageDesigns(String application) {
        List<PageDesign> pageDesignList = this.dPageDesignDao.selectByApplication(application);
        List<PageDsl> pageDsls = this.dPageDslDao.selectBasicByApplication(application);
        Map<String, List<PageDsl>> pageDslMap = pageDsls.stream().collect(Collectors.groupingBy(PageDsl::getPageDesignCode));
        ArrayList<QueryPageDesignResDto> res = new ArrayList<QueryPageDesignResDto>();
        for (PageDesign pageDesign : pageDesignList) {
            QueryPageDesignResDto queryPageDesignResDto = QueryPageDesignResDto.create(pageDesign);
            queryPageDesignResDto.setPageDslList(pageDslMap.get(pageDesign.getCode()));
            res.add(queryPageDesignResDto);
        }
        return res;
    }

    @Override
    public String copyPageDesign(String code, String application) {
        PageDesign pageDesign = this.dPageDesignDao.selectByCodeAndApplication(code, application);
        Assert.notNull((Object)pageDesign, (String)(code + "\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55"));
        List<PageDsl> pageDsls = this.dPageDslDao.selectByPageDesignCode(code, application);
        String deCode = this.buildGeneratorCodeUtil.createStandardCode(application, Boolean.TRUE.equals(pageDesign.getIsMobile()) ? "H5" : "DE");
        pageDesign.setCode(deCode);
        pageDesign.setPublishedTime(null);
        pageDesign.setObjectId(null);
        pageDesign.setName(pageDesign.getName() + "_copy");
        Map<String, MultiLanguageDTO> lang = pageDesign.getLang();
        if (!CollectionUtils.isEmpty(lang) && lang.containsKey("name")) {
            MultiLanguageDTO multiLanguageDTO = lang.get("name");
            multiLanguageDTO.setEn_US((Object)(multiLanguageDTO.getEn_US() + "_copy"));
            multiLanguageDTO.setZh_TW((Object)(multiLanguageDTO.getZh_TW() + "_copy"));
            multiLanguageDTO.setZh_CN((Object)(multiLanguageDTO.getZh_CN() + "_copy"));
        }
        String oldDslCode = pageDesign.getDslCode();
        pageDesign.setDslCode(null);
        UserHelper.fillCreateInfo((Object)pageDesign);
        UserHelper.fillEditInfo((Object)pageDesign);
        for (PageDsl pageDsl : pageDsls) {
            String dslCode = this.buildGeneratorCodeUtil.createStandardCode(application, "DSL");
            if (pageDsl.getCode().equals(oldDslCode)) {
                pageDesign.setDslCode(dslCode);
            }
            pageDsl.setObjectId(null);
            pageDsl.setCode(dslCode);
            pageDsl.setPageDesignCode(deCode);
            UserHelper.fillCreateInfo((Object)((Object)pageDsl));
            UserHelper.fillEditInfo((Object)((Object)pageDsl));
            this.dPageDslDao.save(pageDsl);
        }
        this.dPageDesignDao.save(pageDesign);
        JSONObject pageDesignJo = JSON.parseObject((String)JSON.toJSONString((Object)pageDesign));
        pageDesignJo.put("pageDslList", pageDsls);
        RecordCommitLocal.add((OperationRecordWrapper)new OperationRecordWrapper(pageDesign.getAdpApplication(), "lcdp_pageDesign", (Object)pageDesignJo, "create"));
        return deCode;
    }

    @Override
    public PageDsl createPage(PageDslDto pageDslDto) {
        PageDesign pageDesign = this.dPageDesignDao.selectByCodeAndApplication(pageDslDto.getPageDesignCode(), pageDslDto.getApplication());
        Assert.notNull((Object)pageDesign, (String)(pageDslDto.getPageDesignCode() + "\u4e0d\u80fd\u5b58\u5728"));
        String dslCode = this.buildGeneratorCodeUtil.createStandardCode(pageDslDto.getApplication(), "DSL");
        PageDsl pageDsl = pageDslDto.createPageDsl();
        pageDsl.setCode(dslCode);
        this.dPageDslDao.insert(pageDsl);
        JSONObject pageDesignJo = JSON.parseObject((String)JSON.toJSONString((Object)pageDesign));
        pageDesignJo.put("pageDslList", Arrays.asList(pageDsl));
        RecordCommitLocal.add((OperationRecordWrapper)new OperationRecordWrapper(pageDesign.getAdpApplication(), "lcdp_pageDesign", (Object)pageDesignJo, "create"));
        return pageDsl;
    }

    @Override
    public void deletePageDsl(String code, String pageDesignCode, String application) {
        PageDsl pageDsl = this.dPageDslDao.selectByCodeAndApplication(code, pageDesignCode, application);
        Assert.notNull((Object)((Object)pageDsl), (String)"\u4e0d\u5b58\u5728\u6b64\u9875\u9762");
        this.dPageDslDao.remove(pageDsl);
        PageDesign pageDesign = this.dPageDesignDao.selectByCodeAndApplication(pageDesignCode, application);
        JSONObject pageDesignJo = JSON.parseObject((String)JSON.toJSONString((Object)pageDesign));
        pageDesignJo.put("pageDslList", Arrays.asList(pageDsl));
        RecordCommitLocal.add((OperationRecordWrapper)new OperationRecordWrapper(pageDesign.getAdpApplication(), "lcdp_pageDesign", (Object)pageDesignJo, "delete"));
    }

    @Override
    public void updatePageDslBasic(PageDslDto pageDslDto) {
        PageDsl pageDsl = this.dPageDslDao.selectByCodeAndApplication(pageDslDto.getCode(), pageDslDto.getPageDesignCode(), pageDslDto.getApplication());
        Assert.notNull((Object)((Object)pageDsl), (String)"\u4e0d\u5b58\u5728\u6b64\u9875\u9762");
        pageDsl.setName(pageDslDto.getName());
        pageDsl.setLang(pageDslDto.getLang());
        UserHelper.fillEditInfo((Object)((Object)pageDsl));
        this.dPageDslDao.save(pageDsl);
        PageDesign pageDesign = this.dPageDesignDao.selectByCodeAndApplication(pageDslDto.getPageDesignCode(), pageDslDto.getApplication());
        JSONObject pageDesignJo = JSON.parseObject((String)JSON.toJSONString((Object)pageDesign));
        pageDesignJo.put("pageDslList", Arrays.asList(pageDsl));
        RecordCommitLocal.add((OperationRecordWrapper)new OperationRecordWrapper(pageDesign.getAdpApplication(), "lcdp_pageDesign", (Object)pageDesignJo, "update"));
    }

    @Override
    public void updateActionVersion() {
        List<PageDsl> pageDsls = this.dPageDslDao.findAll();
        HashSet actionIdSet = new HashSet();
        pageDsls.forEach(pageDsl -> {
            Dsl dsl = pageDsl.getDsl();
            List<JSONObject> dataConnectors = dsl.getDataConnectors();
            if (!ObjectUtils.isEmpty(dataConnectors)) {
                dataConnectors.forEach(dataConnector -> {
                    JSONObject extras = dataConnector.getJSONObject("extras");
                    if (!ObjectUtils.isEmpty((Object)extras)) {
                        String serviceName = extras.getString("serviceName");
                        actionIdSet.add(serviceName);
                    }
                });
            }
        });
        List actionIdList = actionIdSet.stream().collect(Collectors.toList());
        Map actionVersionMap = this.actionMetaDataService.getActionInfoByServiceName(new ActionVersionReq().setServiceNames(actionIdList));
        pageDsls.forEach(pageDsl -> {
            Dsl dsl = pageDsl.getDsl();
            List<JSONObject> dataConnectors = dsl.getDataConnectors();
            if (!ObjectUtils.isEmpty(dataConnectors)) {
                dataConnectors.forEach(dataConnector -> {
                    String serviceName;
                    ActionInfoResp versionResp;
                    JSONObject extras = dataConnector.getJSONObject("extras");
                    if (!ObjectUtils.isEmpty((Object)extras) && !ObjectUtils.isEmpty((Object)(versionResp = (ActionInfoResp)actionVersionMap.get(serviceName = extras.getString("serviceName"))))) {
                        String version = versionResp.getServiceVersion();
                        extras.put("serviceVersion", (Object)version);
                        extras.put("source", (Object)"system");
                        dataConnector.put("extras", (Object)extras);
                    }
                });
            }
            this.dPageDslDao.save((PageDsl)((Object)pageDsl));
        });
    }
}

