/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.controller;

import com.digiwin.athena.auth.annotation.FuncAuth;
import com.digiwin.athena.base.ResultBean;
import com.digiwin.athena.domain.PageDsl;
import com.digiwin.athena.dto.CreatePageDesignDto;
import com.digiwin.athena.dto.PageDslDto;
import com.digiwin.athena.dto.QueryPageDesignResDto;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.SavePageDesignBasicInfoReqDto;
import com.digiwin.athena.dto.SavePageDesignReqDto;
import com.digiwin.athena.http.distribution.FxApiHelper;
import com.digiwin.athena.http.distribution.FxRegisterJobInfoResDto;
import com.digiwin.athena.http.distribution.GetFxJobListReqDto;
import com.digiwin.athena.publish.Publish;
import com.digiwin.athena.publish.dto.PublishParam;
import com.digiwin.athena.service.DPageDesignService;
import io.jsonwebtoken.lang.Assert;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pageDesign/d"})
@Tag(name="\u8bbe\u8ba1\u65f6\u4f5c\u4e1a", description="6e6954a1-8237-4526-9114-9c1238b0822b")
@Validated
public class DPageDesignController {
    @Autowired
    private DPageDesignService dPageDesignService;
    @Autowired
    @Qualifier(value="pageDesignPublish")
    private Publish publish;
    @Autowired
    private FxApiHelper fxApiHelper;

    @PostMapping(value={"/createPageDesign"})
    @Operation(summary="\u521b\u5efa\u4f5c\u4e1a")
    public ResultDto<String> createPageDesign(@RequestBody @Validated CreatePageDesignDto createPageDesignDto) {
        String code = this.dPageDesignService.createPageDesign(createPageDesignDto);
        return ResultDto.createSuccess((Object)code);
    }

    @PostMapping(value={"/createPageDsl"})
    public ResultDto<PageDsl> createPageDsl(@RequestBody PageDslDto pageDslDto) {
        PageDsl res = this.dPageDesignService.createPage(pageDslDto);
        return ResultDto.createSuccess((Object)((Object)res));
    }

    @GetMapping(value={"/deletePageDsl"})
    public ResultDto<Boolean> deletePageDsl(String code, String pageDesignCode, String application) {
        this.dPageDesignService.deletePageDsl(code, pageDesignCode, application);
        return ResultDto.createSuccess((Object)true);
    }

    @PostMapping(value={"/updatePageDslBasic"})
    public ResultDto<Boolean> updatePageDslBasic(@RequestBody PageDslDto pageDslDto) {
        this.dPageDesignService.updatePageDslBasic(pageDslDto);
        return ResultDto.createSuccess((Object)true);
    }

    @GetMapping(value={"/queryBasicPageDesign"})
    @Operation(summary="\u67e5\u8be2\u4f5c\u4e1a\u57fa\u7840\u4fe1\u606f")
    public ResultDto<QueryPageDesignResDto> queryBasicPageDesign(@NotEmpty(message="code\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="code\u4e0d\u80fd\u4e3a\u7a7a") String code, @NotEmpty(message="application\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="application\u4e0d\u80fd\u4e3a\u7a7a") String application) {
        QueryPageDesignResDto res = this.dPageDesignService.queryBasicPageDesign(code, application);
        return ResultDto.createSuccess((Object)res);
    }

    @GetMapping(value={"/queryPageDesign"})
    @Operation(summary="\u67e5\u8be2\u4f5c\u4e1a")
    public ResultDto<QueryPageDesignResDto> queryPageDesign(@NotEmpty(message="code\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="code\u4e0d\u80fd\u4e3a\u7a7a") String code, @NotEmpty(message="application\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="application\u4e0d\u80fd\u4e3a\u7a7a") String application) {
        QueryPageDesignResDto res = this.dPageDesignService.queryPageDesign(code, application);
        return ResultDto.createSuccess((Object)res);
    }

    @PostMapping(value={"/savePageDesign"})
    @Operation(summary="\u4fdd\u5b58\u754c\u9762\u8bbe\u8ba1")
    public ResultDto<Boolean> savePageDesign(@RequestBody @Valid List<SavePageDesignReqDto> savePageDesignReqDtoList) {
        Assert.isTrue((!CollectionUtils.isEmpty(savePageDesignReqDtoList) ? 1 : 0) != 0, (String)"\u4fdd\u5b58\u754c\u9762\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        this.dPageDesignService.savePageDesign(savePageDesignReqDtoList);
        return ResultDto.createSuccess((Object)true);
    }

    @PostMapping(value={"/savePageDesignBasicInfo"})
    @Operation(summary="\u4fee\u6539\u4f5c\u4e1a\u57fa\u7840\u4fe1\u606f")
    public ResultDto<Boolean> savePageDesignBasicInfo(@RequestBody @Validated SavePageDesignBasicInfoReqDto savePageDesignBasicInfoReqDto) {
        this.dPageDesignService.savePageDesignBasicInfo(savePageDesignBasicInfoReqDto);
        return ResultDto.createSuccess((Object)true);
    }

    @GetMapping(value={"/deletePageDesign"})
    @Operation(summary="\u5220\u9664\u4f5c\u4e1a")
    public ResultDto<Boolean> deletePageDesign(@NotEmpty(message="code\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="code\u4e0d\u80fd\u4e3a\u7a7a") String code, @NotEmpty(message="application\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="application\u4e0d\u80fd\u4e3a\u7a7a") String application) {
        this.dPageDesignService.deletePageDesign(code, application);
        return ResultDto.createSuccess((Object)true);
    }

    @PostMapping(value={"/singlePublish"})
    @Operation(summary="\u53d1\u5e03\u4f5c\u4e1a")
    @FuncAuth(resourceType="application", resourceId="Var:PublishParam#application", actions={":*"})
    public ResultBean<Date> singlePublish(@RequestBody @Validated PublishParam publishParam) {
        this.publish.publishOne(publishParam);
        QueryPageDesignResDto queryPageDesignResDto = this.dPageDesignService.queryBasicPageDesign(publishParam.getCode(), publishParam.getApplication());
        return ResultBean.success((Object)queryPageDesignResDto.getPublishedTime());
    }

    @GetMapping(value={"/getPagesBasicInfo"})
    @Operation(summary="\u67e5\u8be2\u6307\u5b9a\u4f5c\u4e1a\u4e0b\u9875\u9762\u4fe1\u606f")
    public ResultDto<List<PageDsl>> getPagesBasicInfo(@Schema(description="\u4f5c\u4e1acode") @NotEmpty(message="\u4f5c\u4e1acode\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u4f5c\u4e1acode\u4e0d\u80fd\u4e3a\u7a7a") String code, @Schema(description="\u5e94\u7528code") @NotEmpty(message="\u5e94\u7528code\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u5e94\u7528code\u4e0d\u80fd\u4e3a\u7a7a") String application) {
        List<PageDsl> res = this.dPageDesignService.getPagesBasicInfo(code, application);
        return ResultDto.createSuccess(res);
    }

    @GetMapping(value={"/getAppPageDesigns"})
    @Operation(summary="\u67e5\u8be2\u5e94\u7528\u4e0b\u6240\u6709\u4f5c\u4e1a")
    public ResultDto<List<QueryPageDesignResDto>> getAppPageDesigns(@Schema(description="\u5e94\u7528code") @NotEmpty(message="\u5e94\u7528code\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u5e94\u7528code\u4e0d\u80fd\u4e3a\u7a7a") String application) {
        List<QueryPageDesignResDto> res = this.dPageDesignService.getAppPageDesigns(application);
        return ResultDto.createSuccess(res);
    }

    @GetMapping(value={"/copyPageDesign"})
    @FuncAuth(resourceType="application", resourceId="1", actions={":*"})
    @Operation(summary="\u590d\u5236\u4f5c\u4e1a")
    public ResultDto<String> copyPageDesign(@NotEmpty(message="\u4f5c\u4e1acode\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u4f5c\u4e1acode\u4e0d\u80fd\u4e3a\u7a7a") String code, @NotEmpty(message="\u5e94\u7528code\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u5e94\u7528code\u4e0d\u80fd\u4e3a\u7a7a") String application) {
        String newCode = this.dPageDesignService.copyPageDesign(code, application);
        return ResultDto.createSuccess((Object)newCode);
    }

    @GetMapping(value={"/test1"})
    public List<FxRegisterJobInfoResDto> test1() {
        GetFxJobListReqDto getFxJobListReqDto = new GetFxJobListReqDto();
        getFxJobListReqDto.setGlikesel("DE_c9113682100013f7");
        return this.fxApiHelper.getJobList(getFxJobListReqDto);
    }

    @PostMapping(value={"/updateActionVersion"})
    @Operation(summary="\u5386\u53f2\u6570\u636e\u5904\u7406 - \u5f85\u5220\u9664")
    public ResultDto<String> updateActionVersion() {
        this.dPageDesignService.updateActionVersion();
        return ResultDto.createSuccess((Object)"success");
    }
}

