/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dto;

import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.domain.PageDsl;
import com.digiwin.athena.dto.PageDslDto;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.user.UserHelper;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CreatePageDesignDto {
    @Schema(description="\u6dfb\u52a0\u7c7b\u578b|basic_table-\u57fa\u7840\u8868\u683c\uff0ceditable_table-\u53ef\u7f16\u8f91\u8868\u683c")
    @NotEmpty(message="templateType\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotEmpty(message="templateType\u4e0d\u80fd\u4e3a\u7a7a") String templateType;
    @Schema(description="\u5e94\u7528code")
    private String application;
    @Schema(description="\u4f5c\u4e1a\u540d")
    private String name;
    private String version;
    private String dslCode;
    private Boolean isMobile;
    private Map<String, MultiLanguageDTO> lang;
    private List<PageDslDto> pageDslList = new ArrayList<PageDslDto>();

    public PageDesign createPageDesign() {
        PageDesign pageDesign = new PageDesign();
        pageDesign.setLang(this.lang);
        pageDesign.setName(this.name);
        pageDesign.setAdpApplication(this.application);
        pageDesign.setAdpTenantId(CurThreadInfoUtils.getCurTokenTenant().getTenantId());
        pageDesign.setTemplateType(this.templateType);
        pageDesign.setIsMobile(this.isMobile);
        pageDesign.setDslCode(this.dslCode);
        UserHelper.fillCreateInfo((Object)pageDesign);
        UserHelper.fillEditInfo((Object)pageDesign);
        return pageDesign;
    }

    public PageDsl createPageDsl() {
        PageDsl pageDsl = new PageDsl();
        pageDsl.setAdpApplication(this.application);
        pageDsl.setAdpTenantId(CurThreadInfoUtils.getCurTokenTenant().getTenantId());
        pageDsl.setVersion(this.version);
        UserHelper.fillCreateInfo((Object)((Object)pageDsl));
        UserHelper.fillEditInfo((Object)((Object)pageDsl));
        return pageDsl;
    }

    @Generated
    public CreatePageDesignDto() {
    }

    @Generated
    public String getTemplateType() {
        return this.templateType;
    }

    @Generated
    public String getApplication() {
        return this.application;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getDslCode() {
        return this.dslCode;
    }

    @Generated
    public Boolean getIsMobile() {
        return this.isMobile;
    }

    @Generated
    public Map<String, MultiLanguageDTO> getLang() {
        return this.lang;
    }

    @Generated
    public List<PageDslDto> getPageDslList() {
        return this.pageDslList;
    }

    @Generated
    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }

    @Generated
    public void setApplication(String application) {
        this.application = application;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setDslCode(String dslCode) {
        this.dslCode = dslCode;
    }

    @Generated
    public void setIsMobile(Boolean isMobile) {
        this.isMobile = isMobile;
    }

    @Generated
    public void setLang(Map<String, MultiLanguageDTO> lang) {
        this.lang = lang;
    }

    @Generated
    public void setPageDslList(List<PageDslDto> pageDslList) {
        this.pageDslList = pageDslList;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreatePageDesignDto)) {
            return false;
        }
        CreatePageDesignDto other = (CreatePageDesignDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isMobile = this.getIsMobile();
        Boolean other$isMobile = other.getIsMobile();
        if (this$isMobile == null ? other$isMobile != null : !((Object)this$isMobile).equals(other$isMobile)) {
            return false;
        }
        String this$templateType = this.getTemplateType();
        String other$templateType = other.getTemplateType();
        if (this$templateType == null ? other$templateType != null : !this$templateType.equals(other$templateType)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$dslCode = this.getDslCode();
        String other$dslCode = other.getDslCode();
        if (this$dslCode == null ? other$dslCode != null : !this$dslCode.equals(other$dslCode)) {
            return false;
        }
        Map<String, MultiLanguageDTO> this$lang = this.getLang();
        Map<String, MultiLanguageDTO> other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !((Object)this$lang).equals(other$lang)) {
            return false;
        }
        List<PageDslDto> this$pageDslList = this.getPageDslList();
        List<PageDslDto> other$pageDslList = other.getPageDslList();
        return !(this$pageDslList == null ? other$pageDslList != null : !((Object)this$pageDslList).equals(other$pageDslList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreatePageDesignDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isMobile = this.getIsMobile();
        result = result * 59 + ($isMobile == null ? 43 : ((Object)$isMobile).hashCode());
        String $templateType = this.getTemplateType();
        result = result * 59 + ($templateType == null ? 43 : $templateType.hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $dslCode = this.getDslCode();
        result = result * 59 + ($dslCode == null ? 43 : $dslCode.hashCode());
        Map<String, MultiLanguageDTO> $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : ((Object)$lang).hashCode());
        List<PageDslDto> $pageDslList = this.getPageDslList();
        result = result * 59 + ($pageDslList == null ? 43 : ((Object)$pageDslList).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CreatePageDesignDto(templateType=" + this.getTemplateType() + ", application=" + this.getApplication() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", dslCode=" + this.getDslCode() + ", isMobile=" + this.getIsMobile() + ", lang=" + String.valueOf(this.getLang()) + ", pageDslList=" + String.valueOf(this.getPageDslList()) + ")";
    }
}

