/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.dao.RApplicationCustomConfigMongoDao;
import com.digiwin.athena.dao.RCustomControlRelationMongoDao;
import com.digiwin.athena.dao.UserDefinedCenterMongoDao;
import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.domain.PageDsl;
import com.digiwin.athena.dto.PageDesignDto;
import com.digiwin.athena.dto.SystemParam;
import com.digiwin.athena.dto.TenantInfo;
import com.digiwin.athena.http.distribution.ProgramAuthResDto;
import com.digiwin.athena.mongodb.domain.other.PresetData;
import com.digiwin.athena.mysql.domain.user.UserPO;
import com.digiwin.athena.service.MultiPlatformDiffInterface;
import com.digiwin.athena.service.RPageDesignService;
import com.digiwin.athena.service.RPageDslService;
import com.digiwin.athena.service.RuntimeDataQuery;
import com.digiwin.athena.sys.PresetDataServiceV2;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.user.UserHelper;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Service;

@Service(value="pageDesignRuntime")
public class PageDesignRuntimeDataQuery
implements RuntimeDataQuery {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PageDesignRuntimeDataQuery.class);
    @Autowired
    private MultiPlatformDiffInterface multiPlatformDiffInterface;
    @Resource
    private RPageDesignService rPageDesignService;
    @Autowired
    private PresetDataServiceV2 presetDataServiceV2;
    @Resource
    private RPageDslService rPageDslService;
    @Autowired
    private RCustomControlRelationMongoDao rCustomControlRelationMongoDao;
    @Autowired
    private RApplicationCustomConfigMongoDao rApplicationCustomConfigMongoDao;
    @Autowired
    private UserDefinedCenterMongoDao userDefinedCenterMongoDao;

    public Object queryRuntimeData(JSONObject param) {
        PageDsl pageDsl;
        String code = param.getString("code");
        String dslCode = param.getString("dslCode");
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{code, dslCode})) {
            throw new BusinessException(Integer.valueOf(4003), new Object[0]);
        }
        PageDesignDto pageDesignDto = new PageDesignDto();
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            PageDesign pageDesign = this.rPageDesignService.queryByCode(code);
            if (pageDesign == null) {
                throw new BusinessException(Integer.valueOf(4001), new Object[]{code});
            }
            BeanUtils.copyProperties((Object)pageDesign, (Object)pageDesignDto);
            ProgramAuthResDto programAuth = this.multiPlatformDiffInterface.getProgramAuth(code);
            if (programAuth != null) {
                if (!Boolean.TRUE.equals(programAuth.getAccessible())) {
                    PresetData presetDataObject = this.presetDataServiceV2.getPresetDataObject("4004");
                    throw new BusinessException(Integer.valueOf(4004), new Object[]{code}, JSONObject.parseObject((String)presetDataObject.getValue(), PageDesignDto.class));
                }
                pageDesignDto.setAuthInfo(programAuth.getAuthInfo());
            }
        }
        List sysEnumList = this.multiPlatformDiffInterface.getSysEnumV2();
        ArrayList<JSONObject> sysVariableList = new ArrayList<JSONObject>();
        for (SystemParam systemParam : sysEnumList) {
            JSONObject variable = new JSONObject();
            variable.put("name", (Object)systemParam.getKey());
            variable.put("defaultValue", (Object)systemParam.getValue());
            variable.put("scope", (Object)"system");
            variable.put("description", (Object)systemParam.getDesc());
            sysVariableList.add(variable);
        }
        if (StringUtils.isNotEmpty((CharSequence)dslCode)) {
            pageDsl = this.rPageDslService.queryByCode(dslCode, code);
            if (pageDsl == null) {
                throw new BusinessException(Integer.valueOf(4002), new Object[]{code});
            }
            pageDesignDto.setPageDsl(pageDsl);
        } else if (StringUtils.isNotEmpty((CharSequence)pageDesignDto.getDslCode())) {
            pageDsl = this.rPageDslService.queryByCode(pageDesignDto.getDslCode(), pageDesignDto.getCode());
            pageDesignDto.setPageDsl(pageDsl);
        }
        pageDsl = pageDesignDto.getPageDsl();
        pageDsl.getDsl().getVariables().addAll(sysVariableList);
        String pageDesignCode = pageDsl.getPageDesignCode();
        List adpCodes = this.rCustomControlRelationMongoDao.selectSourceCodeByTargetCode(pageDesignCode);
        if (!adpCodes.isEmpty()) {
            List applicationCustomConfigs = this.rApplicationCustomConfigMongoDao.selectByAdpCodesAndApp(adpCodes, pageDsl.getAdpApplication());
            pageDesignDto.setApplicationCustomConfigs(applicationCustomConfigs);
        }
        TenantInfo curTokenTenant = CurThreadInfoUtils.getCurTokenTenant();
        UserPO currentUser = UserHelper.getCurrentUser();
        Criteria criteria = Criteria.where((String)"conditions.code").is((Object)pageDsl.getPageDesignCode()).and("conditions.dslCode").is((Object)pageDsl.getCode());
        List userDefinedCenters = this.userDefinedCenterMongoDao.selectAllByUserIdAndTenantId(currentUser.getName(), curTokenTenant.getTenantId(), criteria);
        pageDesignDto.setUserDefinedCenters(userDefinedCenters);
        PresetData presetDataObject = this.presetDataServiceV2.getPresetDataObject("system_datasource");
        List dataList = (List)presetDataObject.getObj();
        ArrayList<JSONObject> res = new ArrayList<JSONObject>();
        for (String data : dataList) {
            res.add(JSONObject.parseObject((String)data));
        }
        pageDsl.getDsl().getDataConnectors().addAll(res);
        return pageDesignDto;
    }
}

